/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;

/** This interface provides methods for
* getting and setting various drawing attributes.
* During painting draw layer receives draw context
* and it is expected to either leave draw parameters
* as they are or change them.
*
* @author Miloslav Metelka
* @version 1.00
*/


public interface DrawContext {

    /** Get current foreground color */
    public Color getForeColor();

    /** Set current foreground color */
    public void setForeColor(Color foreColor);

    /** Get current background color */
    public Color getBackColor();

    /** Set current background color */
    public void setBackColor(Color backColor);

    /** Get current underline color */
    public Color getUnderlineColor();

    /** Set current underline color */
    public void setUnderlineColor(Color underlineColor);

    /** Get current wave underline color */
    public Color getWaveUnderlineColor();

    /** Set current wave underline color */
    public void setWaveUnderlineColor(Color waveUnderlineColor);

    /** Get current strike-through color */
    public Color getStrikeThroughColor();

    /** Set current underline color */
    public void setStrikeThroughColor(Color strikeThroughColor);

    /** Get current font */
    public Font getFont();

    /** Set current font */
    public void setFont(Font font);

    /** Get start position of the drawing. This value
    * stays unchanged during the line-number drawing.
    */
    public int getStartOffset();

    /** Get end position of the drawing. This value
    * stays unchanged during the line-number drawing.
    */
    public int getEndOffset();

    /** Is current drawing position at the begining of the line?
    * This flag is undefined for the line-number drawing.
    */
    public boolean isBOL();

    /** Is current drawing position at the end of the line
    * This flag is undefined for the line-number drawing.
    */
    public boolean isEOL();

    /** Get draw info for the component that is currently drawn. */
    public EditorUI getEditorUI();

    /** Get token type number according to the appropriate
    * syntax scanner */
    public TokenID getTokenID();

    /** Get the token-context-path for the token */
    public TokenContextPath getTokenContextPath();

    /** Get starting position in the document of the token being drawn */
    public int getTokenOffset();

    /** Get length of the token text */
    public int getTokenLength();

    /** Get the starting position in the document of the
     * fragment of the token being drawn.
     */
    public int getFragmentOffset();

    /** Get the length of the fragment of the token
     * being drawn
     */
    public int getFragmentLength();

    /** Get the buffer with the characters being drawn. No changes can
    * be done to characters in the buffer.
    */
    public char[] getBuffer();

    /** Get the position in the document where the buffer starts.
     * The area between <tt>getDrawStartOffset()</tt> and <tt>getDrawEndOffset</tt>
     * will contain valid characters. However the first token
     * can start even under <tt>getDrawStartOffset()</tt>. In this case
     * the valid area starts at <tt>getTokenOffset()</tt> of the first
     * token.
     */
    public int getBufferStartOffset();

}
