/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.view.GapMultiLineView;

/**
 * Possibly multi-line view containing one or more folds
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

class FoldMultiLineView extends GapMultiLineView {
    
    /**
     * List containing pairs [fold, ending-line-elem]
     * where ending-line-elem is a line element
     * in which the fold ends.
     */
    private List foldAndEndLineElemList;
    
    FoldMultiLineView(Element firstLineElement, List foldAndEndLineElemList) {
        super(firstLineElement);
        this.foldAndEndLineElemList = foldAndEndLineElemList;
        
        int foldAndEndLineElemListSize = foldAndEndLineElemList.size();
// TODO uncomment        assert (foldAndEndLineElemListSize != 0 // non-empty
            // && ((foldAndEndLineElemListSize & 1) == 0)); // even
  
        setLastLineElement((Element)foldAndEndLineElemList.get(
            foldAndEndLineElemList.size() - 1));
    }

    private JTextComponent getTextComponent() {
        return (JTextComponent)getContainer();
    }
    
    protected boolean useCustomReloadChildren() {
        return true;
    }
    
    protected void reloadChildren(int index, int removeLength, int startOffset, int endOffset) {
        // TODO uncomment assert (index == 0 && removeLength == 0
            // && startOffset == getStartOffset() && endOffset == getEndOffset());

        // Rebuild all the present child views completely
        index = 0;
        removeLength = getViewCount();

        Element lineElem = getElement(); // starting line element
        View[] added = null;
        ViewFactory f = getViewFactory();
        if (f != null) {
            int lineElemEndOffset = lineElem.getEndOffset();
            // Ending offset of the previously created view - here start with
            //   begining of the first line
            int lastViewEndOffset = lineElem.getStartOffset();

            int cnt = foldAndEndLineElemList.size();
            List childViews = new ArrayList();
            for (int i = 0; i < cnt; i++) {
                Fold fold = (Fold)foldAndEndLineElemList.get(i);
                int foldStartOffset = fold.getStartOffset();
                int foldEndOffset = fold.getEndOffset();

                BaseDocument doc = (BaseDocument) lineElem.getDocument();
                try {
                    if (foldStartOffset > lastViewEndOffset) { // need to insert intra-line fragment
                        View lineView = f.create(lineElem); // normal line view
                        View intraFrag = lineView.createFragment(lastViewEndOffset, foldStartOffset);
                        childViews.add(intraFrag);
                        lastViewEndOffset = foldStartOffset;
                    }

                    // Create collapsed view
                    Position viewStartPos = doc.createPosition(foldStartOffset);
                    Position viewEndPos = doc.createPosition(foldEndOffset);
                    CollapsedView collapsedView = new CollapsedView(lineElem,
                        viewStartPos, viewEndPos, fold.getDescription());
                    childViews.add(collapsedView);
                    lastViewEndOffset = foldEndOffset;

                } catch (BadLocationException e) {
                    throw new IllegalStateException("Failed to create view boundary positions"); // NOI18N
                }

                // Fetch line element where the fold ends
                i++;
                lineElem = (Element)foldAndEndLineElemList.get(i);
                lineElemEndOffset = lineElem.getEndOffset();
            }

            // Append ending fragment if necessary
            // asserted non-empty list => foldEndOffset populated
            if (lastViewEndOffset < lineElemEndOffset) { // need ending fragment
                View lineView = f.create(lineElem);
                View endingFrag = lineView.createFragment(lastViewEndOffset, lineElemEndOffset);
                childViews.add(endingFrag);
                // lastViewEndOffset = lineElemEndOffset;  <- can be ignored here
            }

            added = new View[childViews.size()];
            childViews.toArray(added);
        }

        
        replace(index, removeLength, added);
    }
    
}
