/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

/**
 * A given object can publish this interface if it allows
 * an efficient access to its gap-based data storage
 * and wants to give its clients a hint about how to access
 * the data efficiently.
 * <P>For example {@link javax.swing.text.Document} instance
 * having gap-based document content can allow to get an instance
 * of GapStart as a property:<PRE>
 *      GapStart gs = (GapStart)doc.getProperty(GapStart.class);
 *      int gapStart = gs.getGapStart();
 * <PRE>
 * Once the start of the gap is known the client can optimize
 * access to the document's data. For example if the client
 * does not care about the chunks in which it gets the document's data
 * it can access the characters so that no character copying is done:<PRE>
 *      Segment text = new Segment();
 *      doc.getText(0, gapStart, text); // document's data below gap
 *      ...
 *      doc.getText(gapStart, doc.getLength(), text); // document's data over gap
 *      ...
 * <PRE>
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public interface GapStart {

    /**
     * Get the begining of the gap in the object's gap-based data.
     * @return &gt;=0 and &lt;= total size of the data of the object.
     */
    public int getGapStart();

}
