/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import java.util.Map;
import java.util.HashMap;

/** Support for comparing part of char array
* to hash map with strings as keys.
*
* @author Miloslav Metelka
* @version 1.00
*/

public class StringMap extends java.util.HashMap {

    char[] testChars;

    int testOffset;

    int testLen;

    static final long serialVersionUID =967608225972123714L;
    public StringMap() {
        super();
    }

    public StringMap(int initialCapacity) {
        super(initialCapacity);
    }

    public StringMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public StringMap(Map t) {
        super(t);
    }

    public Object get(char[] chars, int offset, int len) {
        testChars = chars;
        testOffset = offset;
        testLen = len;
        Object o = get(this);
        testChars = null; // enable possible GC
        return o;
    }

    public boolean containsKey(char[] chars, int offset, int len) {
        testChars = chars;
        testOffset = offset;
        testLen = len;
        boolean b = containsKey(this);
        testChars = null; // enable possible GC
        return b;
    }

    public Object remove(char[] chars, int offset, int len) {
        testChars = chars;
        testOffset = offset;
        testLen = len;
        Object o = remove(this);
        testChars = null;
        return o;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o instanceof String) {
            String s = (String)o;
            if (testLen == s.length()) {
                for (int i = testLen - 1; i >= 0; i--) {
                    if (testChars[testOffset + i] != s.charAt(i)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        if (o instanceof char[]) {
            char[] chars = (char[])o;
            if (testLen == chars.length) {
                for (int i = testLen - 1; i >= 0; i--) {
                    if (testChars[testOffset + i] != chars[i]) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        return false;
    }

    public int hashCode() {
        int h = 0;
        char[] chars = testChars;
        int off = testOffset;

        for (int i = testLen; i > 0; i--) {
            h = 31 * h + chars[off++];
        }

        return h;
    }

}
