/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

/** Process the batches of the text in the document. This interface
* can be passed to the BaseDocument.processText() and this method
* then calls the processTextBatch() to process the text batches.
*
* @author Miloslav Metelka
* @version 1.00
*/


public interface TextBatchProcessor {

    /** Process one batch of the text.
    * @doc document to work with
    * @startPos starting position of the batch
    * @endPos ending position of the batch
    * @lastBatch whether this batch is the last one in the text area that
    *   is searched.
    * @return non-negative number to stop the batch processing. The returned
    *   value is remembered and returned from BaseDocument.processText().
    *   Negative value means to continue with the next batch.
    */
    public int processTextBatch(BaseDocument doc, int startPos, int endPos,
                                boolean lastBatch);

}
