/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

/**
* Token-id is a unique identifier of a particular token.
* It's not a classical token, because it doesn't contain the image of the token.
* The token image is handled separately in general.
* The common place where the tokens should be defined is
* the appropriate token-context for which they are being
* created.
* The fact that <tt>TokenID</tt> extends <tt>TokenCategory</tt>
* helps to treat the colorings more easily by working with
* <tt>TokenCategory</tt> only (it can be <tt>TokenID</tt> too).
*
* @author Miloslav Metelka
* @version 1.00
*/

public interface TokenID extends TokenCategory {

    /** Get the optional category of the token.
    */
    public TokenCategory getCategory();

}
