/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext;

import java.text.CharacterIterator;

/**
* Character-iterator that operates on the array of characters.
*
* @author Miloslav Metelka
* @version 1.00
*/

public class CharacterArrayIterator implements CharacterIterator {

    char[] chars;

    int beginIndex;

    int endIndex;

    int index;

    public CharacterArrayIterator(char[] chars, int beginIndex, int endIndex) {
        this.chars = chars;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        index = beginIndex;
    }

    private char currentChar() {
        return (index >= beginIndex && index < endIndex) ? chars[index] : DONE;
    }

    public char first() {
        index = beginIndex;
        return currentChar();
    }

    public char last() {
        index = endIndex - 1;
        return currentChar();
    }

    public char current() {
        return currentChar();
    }

    public char next() {
        index = Math.min(index + 1, endIndex);
        return currentChar();
    }

    public char previous() {
        if (index <= beginIndex) {
            return DONE;
        } else {
            return chars[--index];
        }
    }

    public char setIndex(int position) {
        if (position < beginIndex || position >= endIndex) {
            throw new IllegalArgumentException();
        }
        index = position;
        return currentChar();
    }

    public int getBeginIndex() {
        return beginIndex;
    }

    public int getEndIndex() {
        return endIndex;
    }

    public int getIndex() {
        return index;
    }

    public Object clone() {
        return new CharacterArrayIterator(chars, beginIndex, endIndex);
    }

}
