/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.editor.ext;

import javax.swing.JComponent;

/**
 *  Pane displaying the javadoc view and accompanying components
 *  like toolbar for navigation etc. 
 *
 *  @author  Martin Roskanin
 *  @since   03/2002
 */
public interface JavaDocPane {
    
    /** Returns component of JavaDocPane implementation */
    public JComponent getComponent();
    
    /** enables/disables forward button */
    public void setForwardEnabled(boolean enable);

    /** enables/disables back button */
    public void setBackEnabled(boolean enable);
    
    /** enables/disables 'show in external browser' button */
    public void setShowWebEnabled(boolean enable);
    
    public JComponent getJavadocDisplayComponent();
}

