/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.view.spi;

import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

/**
 * View providing an access to the {@link ViewRenderingContext}
 * in the view hierarchy.
 *
 * <p>
 * Accessing of the <code>ViewRenderingContext</code>
 * from a <code>view</code> must always be done like this:<pre>
 *
 *      RenderingContextView rcView = RenderingContextView.get(view);
 *      if (rcView != null) {
 *          rcView.acquireRenderingContext();
 *          try {
 *              ...
 *          } finally {
 *              rcView.releaseRenderingContext();
 *          }
 *      }
 * </pre>
 * 
 * <p>
 * Only one thread at the time can safely access methods
 * of the <code>RenderingContextView</code>. It does not have
 * to be event dispatch thread.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public interface RenderingContextView {
    
    /**
     * Acquire an instance of rendering context.
     * After use it must be released by {@link #releaseContext()}.
     * @param v view for which the rendering context is being obtained.
     */
    public ViewRenderingContext acquireRenderingContext(View v);
    
    /**
     * Release rendering context previously acquired by
     * {@link #acquireRenderingContext(javax.swing.text.View)}.
     * @param vrc rendering context to be released.
     */
    public void releaseRenderingContext(ViewRenderingContext vrc);

 }
