/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.view.spi;

import javax.swing.text.View;

/**
 * Interface describing a view being fragment of some original view.
 * <br>
 * It provides information that the fragment usually has to know anyway
 * but that it's not available through
 * the {@link javax.swing.text.View} class that the fragment is instance of.
 *
 * <p>
 * The instances of this interface are created once fragments
 * of a view have to created e.g. for line-wrapping purposes.
 * <br>
 * If the returned fragment does not implement this interface
 * a default wrapper gets created.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public interface ViewFragment {

    /**
     * Return original view for which this wrapper is being created.
     */
    public View getOriginalView();
    
    /**
     * Return relative starting offset against the starting offset
     * of the original view.
     */
    public int getRelativeStartOffset();
    
    /**
     * Return relative ending offset against the starting offset
     * of the original view.
     */
    public int getRelativeEndOffset();

}
