/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.view.spi;

import javax.swing.text.Element;
import javax.swing.text.View;
import org.netbeans.lib.editor.view.ViewUtilitiesImpl;

/**
 * Various utility methods related to views.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public class ViewUtilities {
    
    private ViewUtilities() {
    }
    

    /**
     * Create view that will cover the whole document.
     */
    public static View createDocumentView(Element elem) {
        return new org.netbeans.lib.editor.view.GapDocumentView(elem);
    }

    /**
     * Check correctness of the hierarchy under the given view.
     * <br>
     * Current checks:
     * <ul>
     *     <li>
     *         Children are Parents are checked to have correct parent info.
     * </ul>
     */
    public static void checkViewHierarchy(View v) {
        ViewUtilitiesImpl.checkViewHierarchy(v);
    }

    /**
     * Test whether the axis is valid.
     *
     * @param axis integer axis
     * @return true if the axis is either <code>View.X_AXIS</code>
     *  or <code>View.Y_AXIS</code>. False is returned otherwise.
     */
    public static boolean isAxisValid(int axis) {
        switch (axis) {
            case View.X_AXIS:
            case View.Y_AXIS:
                return true;
        }
        
        return false;
    }

}
