/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.lib.editor.hyperlink;

import java.util.List;
import org.openide.util.Lookup;

/**
 * This class provides a list of HyperlinkProvider(s) for a given mime type.
 * <br>
 * This class is first searched in the <code>Lookup</code>. If no implementation
 * is found then a default implementation {@link DefaultHyperlinkProviderManager}
 * is constructed.
 *
 * Besides the default implementation there is
 * {@link org.netbeans.modules.editor.hyperlink.LayerHyperlinkProviderManager}
 * in the editor module (non-library part)
 * which reads the hyperlink providers for the mime-types
 * from the xml layer in the System FS.
 * <br>
 * These two existing implementations should suffice for most uses.
 *
 * @author Jan Lahoda
 */
public abstract class HyperlinkProviderManager {
    
    private static HyperlinkProviderManager defaultManager;
    
    /**
     * Find the default hyperlink provider manager in the lookup (or construct
     * a simple default implementation if not found).
     *
     * @return non-null manager.
     */
    public static synchronized HyperlinkProviderManager getDefault() {
        if (defaultManager == null) {
            defaultManager = createDefault();
        }
        return defaultManager;
    }
    
    private static HyperlinkProviderManager createDefault() {
        HyperlinkProviderManager mgr = (HyperlinkProviderManager)Lookup.getDefault().
                lookup(HyperlinkProviderManager.class);

        if (mgr == null) { // not found in lookup -> use default
            mgr = new DefaultHyperlinkProviderManager();
        }
        return mgr;
    }
    
    /**
     * Provide List of HyperlinkProvider(s) for a given mime type.
     * 
     * @param mimeType mime type to test
     * @param List of HyperlinkProvider(s) for a given mime type.
     */
    public abstract List/*<HyperlinkProvider>*/ getHyperlinkProviders(String mimeType);
    
}
