/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
/**
 *
 * @author Martin Roskanin
 */
public class TestMimeLookupInitializer implements MimeLookupInitializer{
    
    private static Map mimeType2Result = new HashMap();
    private static Map mimePath2Lookup = new HashMap();    
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    
    private TestMimeLookupInitializer parent;
    private String[] mimePath;
    
    /** Creates a new instance of TestClass2LayerFolderInitializer */
    public TestMimeLookupInitializer() {
        this.parent = null;
        this.mimePath = EMPTY_STRING_ARRAY;
    }
    
    public TestMimeLookupInitializer(TestMimeLookupInitializer parent, String mimeType){
        this.parent = parent;
        String[] parentMimePath = (parent != null)
            ? parent.mimePath
            : EMPTY_STRING_ARRAY;

        int parentMimePathLength = parentMimePath.length;
        mimePath = new String[parentMimePathLength + 1];
        System.arraycopy(parentMimePath, 0, mimePath, 0, parentMimePathLength);
        mimePath[parentMimePathLength] = mimeType;
    }
    

    public synchronized org.openide.util.Lookup.Result child(String mimeType) { 
        Lookup.Result result = (Lookup.Result) mimeType2Result.get(mimeType);
        if (result == null){
            result = new ProxyChildResult(this, mimeType);
            mimeType2Result.put(mimeType, result);
        }
        return result;
    }

    public org.openide.util.Lookup lookup() {
        Lookup lookup = (Lookup)mimePath2Lookup.get(mimePath);
        if (lookup == null){
            InstanceContent ic = new InstanceContent();
            if ("text/test".equals(mimePath2String(mimePath))) {
                ic.add(new StringBuffer());
            }
            lookup = new AbstractLookup(ic);
            mimePath2Lookup.put (mimePath, lookup);
        }
        return lookup;
    }
    
    private String mimePath2String(String[] mimePath){
        StringBuffer sb = new StringBuffer();
        for (int i=0; i<mimePath.length; i++){
            sb.append(mimePath[i]);
            if (i < mimePath.length-1){
                sb.append("/"); //NOI18N
            }
        }
        return sb.toString();
    }
    
    private class ProxyChildResult extends Lookup.Result {

        private TestMimeLookupInitializer parent;
        private String mimeType;
        private Collection instances = null;
        
        public ProxyChildResult(TestMimeLookupInitializer parent, String mimeType){
            this.parent = parent;
            this.mimeType = mimeType;
        }
        
        public void removeLookupListener(LookupListener l) {}
        public void addLookupListener(LookupListener l) {}

        public synchronized Collection allInstances() {
            if (instances == null) {
                ArrayList ret = new ArrayList();
                ret.add(new TestMimeLookupInitializer(parent, mimeType));
                instances = Collections.unmodifiableCollection(ret);
            }
            return instances;
        }
    }

}
