/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.util.NbBundle;


class CodeTemplatesModel implements TableModelListener {

    // A mime type is something like text/x-java and a language is a localized name of
    // the programming language denoted by a mime type (e.g. Java).
    
    private List/*<String>*/ languages = new ArrayList();
    private Map/*<String, String>*/ languageToMimeType = new HashMap();
    private Set/*<String>*/ modifiedLanguages = new HashSet();
    private Map/*<String, DefaultTableModel>*/ languageToModel = new HashMap();
    private Map/*<DefaultTableModel, String>*/ modelToLanguage = new HashMap();
    
    
    CodeTemplatesModel () {
        
        Vector columns = new Vector ();
        columns.add (loc ("Abbreviation_Title"));
        columns.add (loc ("Expanded_Text_Title"));

        Set mimeTypes = EditorSettings.getDefault().getAllMimeTypes();
        for(Iterator i = mimeTypes.iterator(); i.hasNext(); ) {
            String mimeType = (String) i.next();
            
            // Skip compound mime types (e.g. text/x-ant+xml), they inherit
            // code templates from their base mime type
            if (isCompoundMimeType(mimeType)) { //NOI18N
                continue;
            }
            
            // Find BaseOptions
            BaseOptions baseOptions = (BaseOptions) MimeLookup.getMimeLookup(mimeType).lookup(BaseOptions.class);
            if (baseOptions == null) {
                continue;
            }
            
            // Add the language and its mime type to the map
            String language = EditorSettings.getDefault().getLanguageName(mimeType);
            languages.add(language);
            Collections.sort(languages);
            languageToMimeType.put(language, mimeType);
            
            // Load the code templates
            Map abbreviationsMap = baseOptions.getAbbrevMap ();

            // Load the table
            List table = new ArrayList();
            for(Iterator it2 = abbreviationsMap.keySet().iterator(); it2.hasNext(); ) {
                String abbreviation = (String) it2.next();
                Vector line =  new Vector(2);
                line.add(abbreviation);
                line.add(abbreviationsMap.get(abbreviation));
                table.add(line);
            }
            Collections.sort(table, new MComparator());
            
            // Create the code templates table model for this language
            DefaultTableModel tableModel = new DefaultTableModel(new Vector(table), columns) {
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            
            tableModel.addTableModelListener(this);
            modelToLanguage.put(tableModel, language);
            languageToModel.put(language, tableModel);
        }
        
        expander = BaseOptions.getCodeTemplateExpandKey ();
    }
    
    private boolean isCompoundMimeType(String mimeType) {
        int idx = mimeType.lastIndexOf('+');
        return idx != -1 && idx < mimeType.length() - 1;
    }
    
    List getLanguages () {
        return Collections.unmodifiableList(languages);
    }
    
    String getMimeType (String language) {
        return (String) languageToMimeType.get (language);
    }
    
    DefaultTableModel getTableModel (String language) {
        return (DefaultTableModel) languageToModel.get (language);
    }
    
    void addRow (String language, String abbreviation, String text) {
        DefaultTableModel tableModel = getTableModel (language);
        Vector newLine = new Vector ();
        newLine.add (abbreviation);
        newLine.add (text);
        tableModel.insertRow (0, newLine);
        modifiedLanguages.add (language);
    }
    
    void removeRow (String language, int index) {
        DefaultTableModel tableModel = getTableModel (language);
        tableModel.removeRow (index);
        modifiedLanguages.add (language);
    }
    
    void saveChanges () {
        // Save modified code templates
        for(Iterator i = modifiedLanguages.iterator(); i.hasNext(); ) {
            String language = (String) i.next();
            String mimeType = (String) languageToMimeType.get(language);
            
            // Find BaseOptions
            BaseOptions baseOptions = (BaseOptions) MimeLookup.getMimeLookup(mimeType).lookup(BaseOptions.class);
            
            // Get the code templates from the model
            DefaultTableModel tableModel = getTableModel(language);
            Map abbreviationsMap = new HashMap();
            for (int idx = 0; idx < tableModel.getRowCount(); idx++) {
                abbreviationsMap.put(
                    tableModel.getValueAt(idx, 0),
                    tableModel.getValueAt(idx, 1)
                    );
            }
            
            // Save the code templates
            baseOptions.setAbbrevMap(abbreviationsMap);
        }

        // Save modified expander key
        if (expander != null && !BaseOptions.getCodeTemplateExpandKey().equals(expander)) {
            BaseOptions.setCodeTemplateExpandKey(expander);
        }
    }
    
    boolean isChanged () {
        return !modifiedLanguages.isEmpty () ||
            !BaseOptions.getCodeTemplateExpandKey ().equals (expander);
    }
    
    public void tableChanged (TableModelEvent e) {
        DefaultTableModel tableModel = (DefaultTableModel) e.getSource ();
        String language = (String) modelToLanguage.get (tableModel);
        modifiedLanguages.add (language);
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (CodeTemplatesModel.class, key);
    }
    
    KeyStroke getExpander () {
        return expander;
    }
    
    private KeyStroke expander;
    void setExpander (KeyStroke expander) {
        this.expander = expander;
    }
    
    private static class MComparator implements Comparator {
        public int compare (Object o1, Object o2) {
            String s1 = (String) ((Vector) o1).get (0);
            String s2 = (String) ((Vector) o2).get (0);
            return s1.compareTo (s2);
        }
    }    
}


