/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.general;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.text.EditorKit;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.IDESettings;

import org.netbeans.spi.options.OptionsCategory;

import org.openide.awt.Mnemonics;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;


/**
 * Implementation of one panel in Options Dialog.
 *
 * @author Jan Jancura
 */
public final class GeneralOptionsPanel extends JPanel implements 
ActionListener {

    private JRadioButton    rbFlatternPackages = new JRadioButton ();
    private JRadioButton    rbTreePackages = new JRadioButton ();
    private JComboBox       cbWebBrowser = new JComboBox ();    
    private JRadioButton    rbNoProxy = new JRadioButton ();
    private JRadioButton    rbSystemProxy = new JRadioButton ();
    private JRadioButton    rbHTTPProxy = new JRadioButton ();
    private JTextField      tfHost = new JTextField (); 
    private JTextField      tfPort = new JTextField (); 
    private JTextField      tfNonProxy = new JTextField (); 
    private JComboBox       cbUpdatePeriod = new JComboBox (new String [] {
                                loc ("CTL_Update_every_startup"),
                                loc ("CTL_Update_every_day"),
                                loc ("CTL_Update_every_week"),
                                loc ("CTL_Update_every_2weeks"),
                                loc ("CTL_Update_every_month"),
                                loc ("CTL_Update_never")
    });
    private JCheckBox       cbAskBeforeCheck = new JCheckBox ();
    
    private boolean         changed = false;
    private GeneralOptionsModel model;
    
    
    GeneralOptionsPanel () {
        cbWebBrowser.getAccessibleContext ().setAccessibleName (loc ("AN_Web_Browser"));
        cbWebBrowser.getAccessibleContext ().setAccessibleDescription (loc ("AD_Web_Browser"));
        tfHost.getAccessibleContext ().setAccessibleName (loc ("AN_Host"));
        tfHost.getAccessibleContext ().setAccessibleDescription (loc ("AD_Host"));
        tfPort.getAccessibleContext ().setAccessibleName (loc ("AN_Port"));
        tfPort.getAccessibleContext ().setAccessibleDescription (loc ("AD_Port"));
        tfNonProxy.getAccessibleContext ().setAccessibleName (loc ("AN_NonProxy"));
        tfNonProxy.getAccessibleContext ().setAccessibleDescription (loc ("AD_NonProxy"));
        cbUpdatePeriod.getAccessibleContext ().setAccessibleName (loc ("AN_Update_Period"));
        cbUpdatePeriod.getAccessibleContext ().setAccessibleDescription (loc ("AD_Update_Period"));
        cbAskBeforeCheck.getAccessibleContext ().setAccessibleName (loc ("AN_Ask_Before_Check"));
        cbAskBeforeCheck.getAccessibleContext ().setAccessibleDescription (loc ("AD_Ask_Before_Check"));
        rbNoProxy.addActionListener (this);
        rbSystemProxy.addActionListener (this);
        rbHTTPProxy.addActionListener (this);
        rbFlatternPackages.addActionListener (this);
        rbTreePackages.addActionListener (this);
        cbWebBrowser.addActionListener (this);
        tfHost.addActionListener (this);
        tfPort.addActionListener (this);
        tfNonProxy.addActionListener (this);
        cbUpdatePeriod.addActionListener (this);
        cbAskBeforeCheck.addActionListener (this);
        
        ButtonGroup bgPackages = new ButtonGroup ();
        bgPackages.add (rbFlatternPackages);
        bgPackages.add (rbTreePackages);
        loc (rbFlatternPackages, "Flattern_Packages");
        loc (rbTreePackages, "Tree_Packages");
        ButtonGroup bgProxy = new ButtonGroup ();
        bgProxy.add (rbNoProxy);
        bgProxy.add (rbSystemProxy);
        bgProxy.add (rbHTTPProxy);
        loc (rbNoProxy, "No_Proxy");
        loc (rbSystemProxy, "Use_System_Proxy_Settings");
        loc (rbHTTPProxy, "Use_HTTP_Proxy");
        tfPort.setColumns (4);
        
        FormLayout layout = new FormLayout(
            "5dlu, l:p, 5dlu, p:g, 5dlu, l:p, 5dlu, p", // cols
            "p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu" +
            ", p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p"); // rows
        PanelBuilder builder = new PanelBuilder (layout, this);
        CellConstraints cc = new CellConstraints ();
        CellConstraints lc = new CellConstraints ();
        builder.addSeparator (loc ("General"),          cc.xyw (1,  1, 8));
        builder.addLabel (    loc ("Package_View_Type"),lc.xy  (2,  3),
                              rbFlatternPackages,       cc.xyw (4,  3, 3));
        builder.add (         rbTreePackages,           cc.xyw (4,  5, 3));
        builder.addLabel (    loc ("Web_Browser"),      lc.xy  (2,  7), 
                              cbWebBrowser,             cc.xyw  (4,  7, 5));

        builder.addSeparator (loc ("Proxy_Settings"),   cc.xyw (1,  9, 8));
        builder.addLabel (    loc ("Web_Proxy"),        lc.xy  (2,  11), 
                              rbNoProxy,                cc.xyw (4,  11, 3));
        builder.add (         rbSystemProxy,            cc.xyw (4,  13, 3));
        builder.add (         rbHTTPProxy,              cc.xyw (4,  15, 3));
        builder.addLabel (    loc ("Proxy_Host"),       lc.xy  (2,  17), 
                              tfHost,                   cc.xyw (4,  17, 1));
        builder.addLabel (    loc ("Proxy_Port"),       lc.xy  (6,  17),
                              tfPort,                   cc.xyw (8,  17, 1));
        builder.addLabel (    loc ("Non_Proxy"),        lc.xy  (2,  19),
                              tfNonProxy,               cc.xyw (4,  19, 5));
        builder.addLabel (    loc ("Non_Proxy_Hint"),   lc.xy (4, 21));

        builder.addSeparator (loc ("Auto_Update"),      cc.xyw (1,  23, 8));
        builder.addLabel (    loc ("Check_Period"),     lc.xy  (2,  25),
                              cbUpdatePeriod,           cc.xyw (4,  25, 5));
        builder.addLabel (    loc ("Ask_Before_Check"), lc.xy  (2,  27),
                              cbAskBeforeCheck,         cc.xyw (4,  27, 3));

        // if system proxy setting is not detectable, disable this radio
        // button
        
        if (System.getProperty("netbeans.system_http_proxy") == null) // NOI18N
            rbSystemProxy.setEnabled(false);
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (GeneralOptionsPanel.class, key);
    }
    
    private static void loc (Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext ().setAccessibleName (loc ("AN_" + key));
            c.getAccessibleContext ().setAccessibleDescription (loc ("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText (
                (AbstractButton) c, 
                loc ("CTL_" + key)
            );
        } else {
            Mnemonics.setLocalizedText (
                (JLabel) c, 
                loc ("CTL_" + key)
            );
        }
    }
    
    void update () {
        model = new GeneralOptionsModel ();
        
        rbFlatternPackages.setSelected (true);
        
        // proxy settings
        switch (model.getProxyType ()) {
            case 0:
                rbNoProxy.setSelected (true);
                tfHost.setEnabled (false);
                tfPort.setEnabled (false);
                tfNonProxy.setEnabled (false);
                break;
            case 1:
                rbSystemProxy.setSelected (true);
                tfHost.setEnabled (false);
                tfPort.setEnabled (false);
                tfNonProxy.setEnabled (false);
                break;
            default:
                rbHTTPProxy.setSelected (true);
                tfHost.setEnabled (true);
                tfPort.setEnabled (true);
                tfNonProxy.setEnabled (true);
                break;
        }
        tfHost.setText (model.getProxyHost ());
        int port = model.getProxyPort ();
        if (port > 0)
            tfPort.setText (Integer.toString (port));
        else
            tfPort.setText ("");
        tfNonProxy.setText (model.getUserNonProxy ());

        // Autoupdate settings
        cbAskBeforeCheck.setSelected (model.getAutoUpdateAskBeforeCheck ());
        cbUpdatePeriod.setSelectedIndex (model.getAutoUpdatePeriod ());
        
        // web browser settings
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        HtmlBrowser.FactoryEditor editor = new HtmlBrowser.FactoryEditor ();
        editor.setValue (ideSettings.getWWWBrowser ());
        cbWebBrowser.removeAllItems ();
        String[] tags = editor.getTags ();
        int i, k = tags.length;
        for (i = 0; i < k; i++)
            cbWebBrowser.addItem (tags [i]);
        cbWebBrowser.setSelectedItem (editor.getAsText ());
        
        // package view settings
        ClassLoader classLoader = (ClassLoader) Lookup.getDefault ().lookup 
            (ClassLoader.class);
        try {
            Class clazz = classLoader.loadClass 
                ("org.netbeans.modules.java.project.PackageViewSettings");
            SystemOption systemOption = (SystemOption) SystemOption.
                findObject (clazz, true);
            Method method = clazz.getMethod ("getPackageViewType", new Class[0]);
            Integer integer = (Integer) method.invoke 
                (systemOption, new Object[] {});
            if (integer.intValue () == 0)
                rbFlatternPackages.setSelected (true);
            else
                rbTreePackages.setSelected (true);
        } catch (Exception ex) {
            ex.printStackTrace ();
        }
        changed = false;
    }
    
    void applyChanges () {
        // listening on JTextFields dont work!
        // if (!changed) return; 
        
        if (model == null) return;
        
        // proxy settings
        if (rbNoProxy.isSelected ()) {
            model.setProxyType (0);
        } else
        if (rbSystemProxy.isSelected ()) {
            model.setProxyType (1);
        } else {
            model.setProxyType (2);
        }
        model.setProxyHost (tfHost.getText ());
        model.setUserNonProxy (tfNonProxy.getText ());
        try {
            model.setProxyPort (
                Math.max (Integer.parseInt (tfPort.getText ()), 0)
            );
        } catch (NumberFormatException ex) {
            model.setProxyPort (0);
        }

        // Autoupdate settings
        model.setAutoUpdateAskBeforeCheck (cbAskBeforeCheck.isSelected ());
        model.setAutoUpdatePeriod (cbUpdatePeriod.getSelectedIndex ());
        
        // web browser settings
        IDESettings ideSettings = (IDESettings) IDESettings.findObject 
            (IDESettings.class, true);
        HtmlBrowser.FactoryEditor editor = new HtmlBrowser.FactoryEditor ();
        editor.setAsText ((String) cbWebBrowser.getSelectedItem ());
        ideSettings.setWWWBrowser (
            (org.openide.awt.HtmlBrowser.Factory) editor.getValue ()
        );
        
        // package view settings
        ClassLoader classLoader = (ClassLoader) Lookup.getDefault ().lookup 
            (ClassLoader.class);
        try {
            Class clazz = classLoader.loadClass 
                ("org.netbeans.modules.java.project.PackageViewSettings");
            SystemOption systemOption = (SystemOption) SystemOption.
                findObject (clazz, true);
            Method method = clazz.getMethod 
                ("setPackageViewType", new Class [] {Integer.TYPE});
            Integer integer = new Integer (1);
            if (rbFlatternPackages.isSelected ())
                integer = new Integer (0);
            method.invoke (systemOption, new Object[] {integer});
        } catch (Exception ex) {
            ex.printStackTrace ();
        }
    }
    
    void cancel () {
    }
    
    boolean dataValid () {
        return true;
    }
    
    boolean isChanged () {
        if (model == null) return false;
        if (!tfHost.getText ().equals (model.getProxyHost ())) return true;
        if (model.getProxyPort () > 0) {
            if (!tfPort.getText ().equals (Integer.toString (model.getProxyPort ()))) return true;
        } else
            if (!tfPort.getText ().equals ("")) return true;
        if (!tfNonProxy.getText ().equals (model.getUserNonProxy ())) {
            return true;
        }
        return changed;
    }
    
    public void actionPerformed (ActionEvent e) {
        changed = true;
        tfHost.setEnabled (rbHTTPProxy.isSelected ());
        tfPort.setEnabled (rbHTTPProxy.isSelected ());
        tfNonProxy.setEnabled (rbHTTPProxy.isSelected ());
    }
}



