/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.keymap;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.ErrorManager;

/**
 *
 * @author Jan Jancura
 */
public class KeymapListRenderer extends DefaultTreeCellRenderer {
    
    private KeymapViewModel keymapViewModel;
    private static ErrorManager log = ErrorManager.getDefault ().getInstance 
        (KeymapListRenderer.class.getName ());

    
    public KeymapListRenderer (KeymapViewModel keymapViewModel) {
        if (keymapViewModel == null) throw new NullPointerException ();
        this.keymapViewModel = keymapViewModel;
        //Image i = Utilities.loadImage ("org/openide/resources/actions/empty.gif");
        setLeafIcon (null);
    }
    
    public Component getTreeCellRendererComponent (
        JTree tree, 
        Object value,
        boolean sel,
        boolean expanded,
        boolean leaf, 
        int row,
        boolean hasFocus
    ) {
        super.getTreeCellRendererComponent (tree, value, sel, expanded, leaf, row, hasFocus);
	
	// There needs to be a way to specify disabled icons.
        if (leaf) {
            String displayName = ((ActionImpl) value).getDisplayName ();
            StringBuffer text = new StringBuffer (displayName);
            if (log.isLoggable (1)) {
                text.append (" <");
                text.append (((ActionImpl) value).getId ());
                text.append ("> ");
            }
            String[] shortcuts = keymapViewModel.getShortcuts ((ActionImpl) value);
            if (shortcuts.length == 1)
                text.append ("  [").append (shortcuts [0]).append ("]");
            else 
            if (shortcuts.length > 1) {
                int i, k = shortcuts.length;
                text.append ("  [").append (shortcuts [0]);
                for (i = 1; i < k; i++)
                    text.append (",").append (shortcuts [i]);
                text.append ("]");
            }
//            if (value instanceof Action) {
//                text += " " + ((Action) value).getValue (Action.NAME);
//            }
            setText (text.toString ());
//            Icon icon = getLeafIcon (); //Utils.getIcon (value);
//            if (icon != null) {
//                if (tree.isEnabled ())
//                    setIcon (icon);
//                else
//                    setDisabledIcon (icon);
//            }
        }
	return this;
    }           
}