/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.keymap;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.Utils;
import org.netbeans.spi.options.OptionsCategory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.NotifyDescriptor.InputLine;
import org.openide.NotifyDescriptor.Message;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;


/**
 * Implementation of one panel in Options Dialog.
 *
 * @author Jan Jancura
 */
public class KeymapPanel extends JPanel implements ActionListener, 
TreeSelectionListener, ListSelectionListener {
    
    private JButton             bDelete = new JButton ();
    private JButton             bClone = new JButton ();
    private ButtonGroup         bgViewAs = new ButtonGroup ();
    private JComboBox           cbProfiles = new JComboBox ();
    private JRadioButton        rbAction = new JRadioButton ();
    private JRadioButton        rbShortcut = new JRadioButton ();
    private JTree               tree = new JTree ();
    private JList               lShortcuts = new JList ();
    private JButton             bAddShortcut = new JButton ();
    private JButton             bRemoveShortcut = new JButton ();
    private boolean             listen = false;
    
    
    /** Creates new form KeymapPanel */
    public KeymapPanel () {
        // 1) init components
        loc (bClone,        "Duplicate");
        loc (bDelete,       "Delete");
        loc (rbAction,      "Show_Actions");
        loc (rbShortcut,    "Show_Shortcuts");
        lShortcuts.getAccessibleContext ().setAccessibleName (loc ("AN_Shortcuts"));
        lShortcuts.getAccessibleContext ().setAccessibleDescription (loc ("AD_Shortcuts"));
        tree.getAccessibleContext ().setAccessibleName (loc ("AN_Actions"));
        tree.getAccessibleContext ().setAccessibleDescription (loc ("AD_Actions"));
        cbProfiles.getAccessibleContext ().setAccessibleName (loc ("AN_Profiles"));
        cbProfiles.getAccessibleContext ().setAccessibleDescription (loc ("AD_Profiles"));
        bgViewAs.add        (rbAction);
        bgViewAs.add        (rbShortcut);
        bClone.addActionListener (this);
        bDelete.addActionListener (this);
        rbAction.setSelected (true);
        rbAction.addActionListener (this);
        rbShortcut.addActionListener (this);
        tree.setRootVisible (false);
        tree.setShowsRootHandles (true);
        tree.addTreeSelectionListener (this);
        JScrollPane spTree = new JScrollPane (tree);
        spTree.setPreferredSize (new Dimension (10, 10));
        cbProfiles.addActionListener (this);
        loc (bAddShortcut,       "Add_Shortcut");
        loc (bRemoveShortcut,    "Remove_Shortcut");
        bAddShortcut.addActionListener (this);
        bRemoveShortcut.addActionListener (this);
        lShortcuts.addListSelectionListener (this);
        JScrollPane spShortcuts = new JScrollPane (lShortcuts);
        spShortcuts.setPreferredSize (new Dimension (10, 10));
        bAddShortcut.setEnabled     (false);
        bRemoveShortcut.setEnabled  (false);
        JLabel lbShortcuts = new JLabel ();
        loc (lbShortcuts, "Shortcuts"); // NOI18N
        lbShortcuts.setLabelFor (lShortcuts);
        JLabel lTree = new JLabel ();
        loc (lTree, "Actions");
        lTree.setLabelFor (tree);

        // 2) init layout
        FormLayout layout = new FormLayout (
            "p", // cols
            "p, 3dlu, p");      // rows
        PanelBuilder builder = new PanelBuilder (layout);
        CellConstraints cc = new CellConstraints ();
        CellConstraints lc = new CellConstraints ();
        builder.add (         bAddShortcut,         cc.xy   (1, 1));
        builder.add (         bRemoveShortcut,      cc.xy   (1, 3));
        JPanel pButtons1 = builder.getPanel ();
        
        JPanel pButtons2 = new JPanel (new GridLayout (1, 2, 3, 3));
        pButtons2.add (bClone);
        pButtons2.add (bDelete);
        
        layout = new FormLayout (
            "p:g, 3dlu, p:g", // cols
            "p, 1dlu, p");      // rows
        layout.setColumnGroups (new int[][] {new int[] {1, 3}});
        builder = new PanelBuilder (layout);
        builder.add (lbShortcuts,                   lc.xy   (1, 1));
        builder.add (spShortcuts,                   cc.xy   (1, 3, "f, f"));
        builder.add (         pButtons1,            cc.xy   (3, 3));
        JPanel shortcuts = builder.getPanel ();

        layout = new FormLayout (
            "p, 3dlu, p:g, 5dlu, p", // cols
            "p, 3dlu, p, 1dlu, 50dlu:g, 5dlu, p");      // rows
        builder = new PanelBuilder (layout, this);
        
        builder.addLabel (    loc ("Keymap_Name"),  lc.xy   (1, 1),
                              cbProfiles,           cc.xy   (3, 1));
        builder.add (         pButtons2,            cc.xy   (5, 1));
        
//        builder.addSeparator (loc ("View_By"),      cc.xyw  (10, 1, 4));
//        builder.add (         rbAction,             cc.xy   (11, 3));
//        builder.add (         rbShortcut,           cc.xy   (13, 3));
        
        builder.add (lTree,                         lc.xyw  (1, 3, 5));
        builder.add (spTree,                        cc.xywh (1, 5, 5, 1, "f, f"));
        builder.add (         shortcuts,            cc.xyw  (1, 7, 5));
    }
    
    public void actionPerformed (ActionEvent e) {
        if (!listen) return;
        Object source = e.getSource ();
        if (source == bAddShortcut) {
            Object action = tree.getSelectionPath ().getLastPathComponent ();
            String shortcut = ShortcutsDialog.getShortcut (getModel ());
            if (shortcut == null) return;
            getModel ().addShortcut (
                tree.getSelectionPath (), shortcut
            );
            selectAction (action);
            if (lShortcuts.getModel ().getSize () > 0)
                lShortcuts.setSelectedIndex (0);
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    lShortcuts.requestFocus ();
                }
            });
        } else
        if (source == bRemoveShortcut) {
            int index = lShortcuts.getSelectedIndex ();
            Object action = tree.getSelectionPath ().getLastPathComponent ();
            String shortcut = (String) lShortcuts.getSelectedValue ();
            getModel ().removeShortcut (
                tree.getSelectionPath (), shortcut
            );
            selectAction (action);
            if (lShortcuts.getModel ().getSize () > index)
                lShortcuts.setSelectedIndex (index);
            else
            if (lShortcuts.getModel ().getSize () > 0)
                lShortcuts.setSelectedIndex (0);
        } else
        if (source == bDelete) {
            deleteCurrentProfile ();
        } else
        if (source == cbProfiles) {
            String profile = (String) cbProfiles.getSelectedItem ();
            getModel ().setCurrentProfile (profile);
            if (getModel ().isCustomProfile (profile))
                loc (bDelete, "Delete");                          // NOI18N
            else
                loc (bDelete, "Restore");                         // NOI18N
            refreshAction ();
        } else
        if (source == bClone) {
            InputLine il = new InputLine (
                loc ("CTL_Create_New_Profile_Message"),                // NOI18N
                loc ("CTL_Create_New_Profile_Title")                   // NOI18N
            );
            il.setInputText ((String) cbProfiles.
                getSelectedItem ());
            DialogDisplayer.getDefault ().notify (il);
            if (il.getValue () == NotifyDescriptor.OK_OPTION) {
                String newProfile = il.getInputText ();
                Iterator it = getModel ().getProfiles ().iterator ();
                while (it.hasNext ())
                    if (newProfile.equals (it.next ())) {
                        Message md = new Message (
                            loc ("CTL_Duplicate_Profile_Name"),        // NOI18N
                            Message.ERROR_MESSAGE
                        );
                        DialogDisplayer.getDefault ().notify (md);
                        return;
                    }
                getModel ().cloneProfile (newProfile);
                cbProfiles.addItem (il.getInputText ());
                cbProfiles.setSelectedItem (il.getInputText ());
            }
            return;
        }
    }
    
    public void valueChanged (TreeSelectionEvent e) {
        if (!listen) return;
        refreshAction ();
    }
    
    public void valueChanged (ListSelectionEvent e) {
        if (!listen) return;
        // selected shourtcut changed
        int i = lShortcuts.getSelectedIndex ();
        if (i < 0) {
            bRemoveShortcut.setEnabled (false);
            return;
        }
        bRemoveShortcut.setEnabled (true);
    }
   
    private boolean initialized = false;
    void update () {
        if (!initialized) {
            initialized = true;
            listen = false;

            tree.setCellRenderer (new KeymapListRenderer (getModel ()));
            tree.setModel (getModel ());

            // cbProfiles
            List keymaps = getModel ().getProfiles ();
            cbProfiles.removeAllItems ();
            int i, k = keymaps.size ();
            for (i = 0; i < k; i++)
                cbProfiles.addItem (keymaps.get (i));
            listen = true;
        }
        cbProfiles.setSelectedItem (getModel ().getCurrentProfile ());
    }
    
    private void deleteCurrentProfile () {
        String currentProfile = (String) cbProfiles.getSelectedItem ();
        getModel ().deleteProfile (currentProfile);
        if (getModel ().isCustomProfile (currentProfile)) {
            cbProfiles.removeItem (currentProfile);
            cbProfiles.setSelectedIndex (0);
        }
    }
    
    void applyChanges () {
        if (!initialized) return; // not initialized yet.
        getModel ().apply ();
    }
    
    void cancel () {
        if (model == null) return;
        model.cancel ();
    }
    
    boolean dataValid () {
        return true;
    }
    
    boolean isChanged () {
        return getModel ().isChanged ();
    }
    
    private KeymapViewModel     model;

    KeymapViewModel getModel () {
        if (model == null) 
            model = new KeymapViewModel ();
        return model;
    }
    
    
    // other methods ...........................................................
    
    private static String loc (String key) {
        return NbBundle.getMessage (KeymapPanel.class, key);
    }
    
    private static void loc (Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext ().setAccessibleName (loc ("AN_" + key));
            c.getAccessibleContext ().setAccessibleDescription (loc ("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText (
                (AbstractButton) c, 
                loc ("CTL_" + key)
            );
        } else {
            Mnemonics.setLocalizedText (
                (JLabel) c, 
                loc ("CTL_" + key)
            );
        }
    }
    
    void refreshAction () {
        Object action = tree.getSelectionPath () == null ? 
            null : tree.getSelectionPath ().getLastPathComponent ();
        selectAction (action);
        if (lShortcuts.getModel ().getSize () > 0)
            lShortcuts.setSelectedIndex (0);
    }
    
    void selectAction (Object action) {
        if (action == null || action instanceof String) {
            lShortcuts.setModel (new DefaultListModel ());
            bAddShortcut.setEnabled (false);
            bRemoveShortcut.setEnabled (false);
            return;
        }
        bAddShortcut.setEnabled (true);
        bRemoveShortcut.setEnabled (false);
        final String[] shortcuts = getModel ().getShortcuts ((ActionImpl) action);
        lShortcuts.setModel (new AbstractListModel () {
            public int getSize () {
                return shortcuts.length;
            }
            public Object getElementAt (int i) {
                return shortcuts [i];
            }
        });        
    }
}
