/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.keymap; 

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;



/**
 *
 * @author Jan Jancura
 */
public class ShortcutsDialog {
    
    public static String getShortcut (final ShortcutsFinder shortcutsFinder) {
        FormLayout layout = new FormLayout (
            "p, 3dlu, 180dlu:g",       // cols
            "p, 3dlu, p"        // rows
        );
        PanelBuilder builder = new PanelBuilder (layout);
        builder.setDefaultDialogBorder ();
        CellConstraints cc = new CellConstraints ();
        CellConstraints lc = new CellConstraints ();
        final JTextField tfShortcut = new JTextField ();
        final JLabel lConflict = new JLabel ("  ");
        lConflict.setForeground (Color.red);
        final JButton bTab = new JButton ();
        loc (bTab, "CTL_Tab");
        final JButton bClear = new JButton ();
        loc (bClear, "CTL_Clear");
        tfShortcut.setFocusTraversalKeys (
            KeyboardFocusManager.BACKWARD_TRAVERSAL_KEYS, 
            Collections.EMPTY_SET
        );
        tfShortcut.setFocusTraversalKeys (
            KeyboardFocusManager.DOWN_CYCLE_TRAVERSAL_KEYS, 
            Collections.EMPTY_SET
        );
//        tfShortcut.setFocusTraversalKeys (
//            KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS, 
//            Collections.EMPTY_SET
//        );
        tfShortcut.setFocusTraversalKeys (
            KeyboardFocusManager.UP_CYCLE_TRAVERSAL_KEYS, 
            Collections.EMPTY_SET
        );
        class Listener implements ActionListener, KeyListener {

            private KeyStroke backspaceKS = KeyStroke.getKeyStroke 
                (KeyEvent.VK_BACK_SPACE, 0);
            private KeyStroke tabKS = KeyStroke.getKeyStroke 
                (KeyEvent.VK_TAB, 0);
            
            private String key = "";

            public void keyTyped (KeyEvent e) {
                e.consume ();
            }

            public void keyPressed (KeyEvent e) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke (
                    e.getKeyCode (),
                    e.getModifiers ()
                );
                
                boolean add = e.getKeyCode () != e.VK_SHIFT &&
                              e.getKeyCode () != e.VK_CONTROL &&
                              e.getKeyCode () != e.VK_ALT &&
                              e.getKeyCode () != e.VK_META &&
                              e.getKeyCode () != e.VK_ALT_GRAPH;
                
                if (keyStroke.equals (backspaceKS) && !key.equals ("")) {
                    // delete last key
                    int i = key.lastIndexOf (' ');
                    if (i < 0) 
                        key = "";
                    else
                        key = key.substring (0, i);
                    tfShortcut.setText (key);
                } else
                    // add key
                    addKeyStroke (keyStroke, add);
                
                if (add) updateWarning ();
                e.consume ();
            }

            public void keyReleased (KeyEvent e) {
                e.consume ();
            }
            
            public void actionPerformed (ActionEvent e) {
                if (e.getSource () == bClear) {
                    key = "";
                    tfShortcut.setText (key);
                } else 
                if (e.getSource () == bTab)
                    addKeyStroke (tabKS, true);
            }
            
            private void updateWarning () {
                ActionImpl action = shortcutsFinder.findActionForShortcut 
                    (tfShortcut.getText ());
                if (action != null) {
                    lConflict.setText (MessageFormat.format (
                        loc ("Shortcut_Conflict"), 
                        new Object[] {action.getDisplayName ()}
                    ));
                } else 
                    lConflict.setText ("");
            }
            
            private void addKeyStroke (KeyStroke keyStroke, boolean add) {
                String k = Utils.getKeyStrokeAsText (keyStroke);
                if (key.equals ("")) {
                    tfShortcut.setText (k);
                    if (add) key = k;
                } else {
                    tfShortcut.setText (key + " " + k);
                    if (add) key += " " + k;
                }
            }
        }
        Listener listener = new Listener ();
        tfShortcut.addKeyListener (listener);
        builder.addLabel (
            loc ("Shortcut"), lc.xy   (1, 1), 
            tfShortcut, cc.xy   (3, 1)
        );
        builder.add (lConflict, cc.xyw (1, 3, 3));
        DialogDescriptor descriptor = new DialogDescriptor (
            builder.getPanel (),
            loc ("Add_Shortcut_Dialog"),
            true,
            new Object[] {
                DialogDescriptor.OK_OPTION,
                DialogDescriptor.CANCEL_OPTION
            },
            DialogDescriptor.OK_OPTION,
            DialogDescriptor.DEFAULT_ALIGN,
            null, 
            listener
        );
        descriptor.setClosingOptions (new Object[] {
            DialogDescriptor.OK_OPTION,
            DialogDescriptor.CANCEL_OPTION
        });
        descriptor.setAdditionalOptions (new Object [] {
            bClear, bTab
        });
        DialogDisplayer.getDefault ().notify (descriptor);
        if (descriptor.getValue () == DialogDescriptor.OK_OPTION)
            return tfShortcut.getText ();
        return null;
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (ShortcutsDialog.class, key);
    }
    
    private static void loc (Component c, String key) {
        if (c instanceof AbstractButton)
            Mnemonics.setLocalizedText (
                (AbstractButton) c, 
                loc (key)
            );
        else
            Mnemonics.setLocalizedText (
                (JLabel) c, 
                loc (key)
            );
    }
    
    public interface ShortcutsFinder {
        ActionImpl findActionForShortcut (String shortcuts);
    }
}
