/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.macros;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.ExtKit;

import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.EditorBridge;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;


class MacrosModel {
    
    private KeymapViewModel keymapModel;
    /** Map (String (macro name) > String (macro text)).*/
    private Map             macroNameToText;
    private DefaultTableModel tableModel;
    private boolean         changed = false;

    
    MacrosModel (Lookup lookup) {
        keymapModel = (KeymapViewModel) lookup.lookup 
            (KeymapViewModel.class);
        init ();
    }
    
    private void init () {
        
        // 1) init macroNameToText
        macroNameToText = new HashMap ();
        Iterator it = AllOptionsFolder.getDefault ().getInstalledOptions ().
            iterator ();    
        while (it.hasNext ()) {
            Class optionsClass = (Class) it.next ();
            BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
                (optionsClass, true);
            
            macroNameToText.putAll (baseOptions.getMacroMap ());
        }
        macroNameToText.remove (null);
        
        // load shortcuts & create data for table
        it = macroNameToText.keySet ().iterator ();
        Vector data = new Vector ();
        while (it.hasNext ()) {
            String macroName = (String) it.next ();
            String shortcut = "";
            ActionImpl action = keymapModel.findActionForId 
                ("macro-" + macroName);
            if (action == null)
                action = keymapModel.findActionForId (macroName);
            if (action != null) {
                String[] shortcuts = keymapModel.getShortcuts (action);
                if (shortcuts.length > 0)
                    shortcut = shortcuts [0];
            }
            Vector line = new Vector ();
            line.add (macroName);
            line.add (shortcut);
            data.add (line);
        }
        Collections.sort (data, new MComparator ());
        Vector columns = new Vector (2);
        columns.add (loc ("Macro_Name_Title"));
        columns.add (loc ("Macro_Code_Title"));
        tableModel = new DefaultTableModel (data, columns) {
            public boolean isCellEditable (int row, int column) {
                return false;
            }
        };
        tableModel.getColumnName(2);
    }
    
    DefaultTableModel getShortcutsTableModel () {
        return tableModel;
    }
    
    boolean isChanged () {
        return changed;
    }
    
    Collection getMacroNames () {
        return Collections.unmodifiableCollection (macroNameToText.keySet ());
    }
    
    String getMacroText (String macroName) {
        return (String) macroNameToText.get (macroName);
    }
    
    void addMacro (String macroName, String text) {
        tableModel.insertRow (0, new Object [] {macroName, text});
        macroNameToText.put (macroName, text);
    }
    
    void removeMacro (int index) {
        String macroName = (String) tableModel.getValueAt (index, 0);
        macroNameToText.remove (macroName);
        tableModel.removeRow (index);
    }
    
    void setMacroText (String macroName, String text) {
        if (macroNameToText.containsKey (macroName) && 
            text.equals (macroNameToText.get (macroName))
        ) return;
        macroNameToText.put (macroName, text);
        changed = true;
    }
    
    void setShortcut (int index, String shortcut) {
        tableModel.setValueAt (shortcut, index, 1);
//        BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
//            (BaseOptions.class, true);
//        baseOptions.setMacroMap (new HashMap (macroNameToText));
//        BaseKit editorKit = BaseKit.getKit (ExtKit.class);
//        TextAction textAction = (TextAction) editorKit.getActionByName 
//            ("macro-" + tableModel.getValueAt (index, 0));
//        System.out.println("textAction " + textAction);
//        ActionImpl actionImpl = new EditorBridge.EditorAction (textAction);
        saveMacros ();
        keymapModel.refreshActions ();
        ActionImpl actionImpl = keymapModel.findActionForId (
            BaseKit.macroActionPrefix + tableModel.getValueAt (index, 0)
        );
        keymapModel.setShortcuts (actionImpl, Collections.singleton (shortcut));
        changed = true;
    }

    void applyChanges () {
        saveMacros ();
        changed = false;
    }
    
    void cancel () {
        init ();
        changed = false;
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (MacrosPanel.class, key);
    }
    
    private void saveMacros () {
        Iterator it = AllOptionsFolder.getDefault ().getInstalledOptions ().
            iterator ();
        while (it.hasNext ()) {
            Class optionsClass = (Class) it.next ();
            BaseOptions baseOptions = (BaseOptions) BaseOptions.findObject 
                (optionsClass, true);
            
            baseOptions.setMacroMap (new HashMap (macroNameToText));
        }
    }
    
    
    // innerclasses ............................................................
    
    private static class MComparator implements Comparator {
        public int compare (Object o1, Object o2) {
            String s1 = (String) ((Vector) o1).get (0);
            String s2 = (String) ((Vector) o2).get (0);
            return s1.compareTo (s2);
        }
    }    
}
