/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.macros;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.NotifyDescriptor.InputLine;

import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;


/**
 * Implementation of one panel in Options Dialog.
 *
 * @author Jan Jancura
 */
public final class MacrosPanel extends JPanel implements 
ActionListener, ListSelectionListener {

    
    private JTable          tMacros = new JTable ();
    private JScrollPane     spTable = new JScrollPane (tMacros);
    private JEditorPane     epMacro = new JEditorPane ();
    private JButton         bNew = new JButton ();
    private JButton         bRemove = new JButton ();
    private JButton         bShortcut = new JButton ();
    
    private MacrosModel     model;
    private boolean         listen = true;
    private String          currentMacro;
    
    
    public MacrosPanel () {
        
        // 1) init components
        tMacros.getAccessibleContext ().setAccessibleName (loc ("AN_Macros_Table"));
        tMacros.getAccessibleContext ().setAccessibleDescription (loc ("AD_Macros_Table"));
        epMacro.getAccessibleContext ().setAccessibleName (loc ("AN_Macro"));
        epMacro.getAccessibleContext ().setAccessibleDescription (loc ("AD_Macro"));
        bRemove.setEnabled (false);
        bShortcut.setEnabled (false);
        loc (bNew, "New_Macro");
        loc (bRemove, "Remove_Macro");
        loc (bShortcut, "Shortcut");
        bNew.addActionListener (this);
        bRemove.addActionListener (this);
        bShortcut.addActionListener (this);
        tMacros.getSelectionModel ().setSelectionMode 
            (ListSelectionModel.SINGLE_SELECTION);
        tMacros.getSelectionModel ().addListSelectionListener (this);
        tMacros.getTableHeader ().setReorderingAllowed (false);
        spTable.setPreferredSize (new Dimension (10, 10));
        epMacro.setEditorKit(JEditorPane.createEditorKitForContentType("text/plain"));
        epMacro.setPreferredSize (new Dimension (10, 10));
        JScrollPane spMacro = new JScrollPane (epMacro);
        spMacro.setPreferredSize (new Dimension (10, 10));
        JLabel lbMacros = new JLabel ();
        loc (lbMacros, "Macro_List");
        lbMacros.setLabelFor (tMacros);
        JLabel lbMacroCode = new JLabel ();
        loc (lbMacroCode, "Macro_Code");
        lbMacroCode.setLabelFor (epMacro);

        // 2) init layout
        FormLayout layout = new FormLayout (
            "200dlu:g, 5dlu, p", // cols
            "p, 1dlu, p, 3dlu, p, 3dlu, p, f:20dlu:g, 5dlu, p, 1dlu, f:20dlu:g" // rows
        );
        layout.setRowGroups (new int[][] {{3, 7}});
        PanelBuilder builder = new PanelBuilder (layout, this);
        CellConstraints cc = new CellConstraints ();
        CellConstraints lc = new CellConstraints ();
        builder.add (     lbMacros,                        lc.xy (1, 1));
        builder.add (     spTable,                         cc.xywh (1, 3, 1, 6));
        builder.add (     bNew,                            cc.xy (3, 3));
        builder.add (     bShortcut,                       cc.xy (3, 5));
        builder.add (     bRemove,                         cc.xy (3, 7));
        builder.add (     lbMacroCode,                     lc.xy (1, 10));
        builder.add (     spMacro,                         cc.xy (1, 12));
    }
    
    private static String loc (String key) {
        return NbBundle.getMessage (MacrosPanel.class, key);
    }
    
    private static void loc (Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext ().setAccessibleName (loc ("AN_" + key));
            c.getAccessibleContext ().setAccessibleDescription (loc ("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText (
                (AbstractButton) c, 
                loc ("CTL_" + key)
            );
        } else {
            Mnemonics.setLocalizedText (
                (JLabel) c, 
                loc ("CTL_" + key)
            );
        }
    }
    
    public void update () {
        model = new MacrosModel (lookup);
        listen = false;
        DefaultTableModel tableModel = model.getShortcutsTableModel ();
        currentMacro = null;
        tableModel.setColumnIdentifiers (new String[] {
            loc ("Macro_Name_Title"),
            loc ("Macro_Code_Title")
        });
        tMacros.setModel (tableModel);
        listen = true;
        if (model.getMacroNames().size () > 0) 
            tMacros.getSelectionModel ().setSelectionInterval (0, 0);
    }
    
    public void applyChanges () {
        saveCurrentMacro ();
        if (model != null)
            model.applyChanges ();
    }
    
    public void cancel () {
        if (model != null)
            model.cancel ();
    }
    
    public boolean dataValid () {
        return true;
    }
    
    public boolean isChanged () {
        if (model == null) return false;
        return model.isChanged ();
    }
    
    private Lookup lookup;
    
    void setLookup (Lookup lookup) {
        this.lookup = lookup;
    }
    
    
    // ActionListener ..........................................................
    
    public void actionPerformed (ActionEvent e) {
        if (!listen) return;
        if (e.getSource () == bNew) {
            InputLine descriptor = new InputLine (
                loc ("CTL_Enter_macro_name"),
                loc ("CTL_New_macro_dialog_title")
            );
            if (DialogDisplayer.getDefault ().notify (descriptor) ==
                InputLine.OK_OPTION
            ) {
                String macroName = descriptor.getInputText ().trim ();
                if (macroName.length () == 0) {
                    DialogDisplayer.getDefault ().notify (
                        new NotifyDescriptor.Message (
                            loc ("CTL_Empty_Macro_Name"),
                            NotifyDescriptor.ERROR_MESSAGE
                        )
                    );
                } else {
                    Iterator it = model.getMacroNames ().iterator ();
                    boolean duplicate = false;
                    while (it.hasNext ()) {
                        String name = (String) it.next ();
                        if (macroName.equals (name)) {
                            DialogDisplayer.getDefault ().notify (
                                new NotifyDescriptor.Message (
                                    loc ("CTL_Duplicate_Macro_Name"),
                                    NotifyDescriptor.ERROR_MESSAGE
                                )
                            );
                            duplicate = true;
                            break;
                        }
                    }
                    if (!duplicate) {
                        listen = false;
                        model.addMacro (macroName, "");
                        listen = true;
                        tMacros.getSelectionModel ().setSelectionInterval (0, 0);
                        spTable.getVerticalScrollBar ().setValue (0);
                    }
                }
            }
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    epMacro.requestFocus ();
                }
            });
        } else
        if (e.getSource () == bRemove) {
            int index = tMacros.getSelectedRow ();
            listen = false;
            model.removeMacro (index);
            listen = true;
            currentMacro = null;
            if (index < tMacros.getModel ().getRowCount ())
                tMacros.getSelectionModel ().setSelectionInterval 
                    (index, index);
            else
            if (tMacros.getModel ().getRowCount () > 0)
                tMacros.getSelectionModel ().setSelectionInterval (
                    tMacros.getModel ().getRowCount () - 1,
                    tMacros.getModel ().getRowCount () - 1
                );
            else {
                bRemove.setEnabled (false);
                bShortcut.setEnabled (false);
            }
        } else
        if (e.getSource () == bShortcut) {
            int index = tMacros.getSelectedRow ();
            String shortcut = ShortcutsDialog.getShortcut (
                (KeymapViewModel) lookup.lookup (KeymapViewModel.class)
            );
            saveCurrentMacro ();
            if (shortcut != null)
                model.setShortcut (index, shortcut);
            SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    epMacro.requestFocus ();
                }
            });
        }
    }
    
    public void valueChanged (ListSelectionEvent e) {
        int index = tMacros.getSelectedRow ();
        if (index < 0) {
            epMacro.setText ("");
            bRemove.setEnabled (false);
            bShortcut.setEnabled (false);
            return;
        }
        saveCurrentMacro ();
        
        bRemove.setEnabled (true);
        bShortcut.setEnabled (true);
        String name = getCurrentMacro ();
        String text = model.getMacroText (name);
        epMacro.setText (text);
        currentMacro = name;
    }

    private String getCurrentMacro () {
        int index = tMacros.getSelectedRow ();
        if (index < 0) return null;
        return (String) tMacros.getModel ().getValueAt (index, 0);
    }
    
    private void saveCurrentMacro () {
        if (currentMacro == null) return;
        if (epMacro.getText ().equals (model.getMacroText (currentMacro)))
            return;
        model.setMacroText (currentMacro, epMacro.getText ());
        firePropertyChange (OptionsPanelController.PROP_CHANGED, null, null);
    }
}


