/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sound.midi.SysexMessage;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;

/**
 *
 *  @author Jan Jancura
 */
public class MimeLookupInitializerImpl implements MimeLookupInitializer {

    private String[]	mimeTypes;
    private Map         children = new HashMap(); //<mimetype, child Lookup.Result>
    
    public MimeLookupInitializerImpl () {
        this (new String [0]);
    }
    
    public MimeLookupInitializerImpl (String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }
    
    /**
     * Lookup providing mime-type sensitive or global-level data
     * depending on which level this initializer is defined.
     * 
     * @return Lookup or null, if there are no lookup-able objects for mime or global level.
     */
    public Lookup lookup () {
	return _lookup ();
    }
    
    /**
     * Retrieves a Lookup.Result of MimeLookupInitializers for the given sub-mimeType.
     *
     * @param mimeType mime-type string representation e.g. "text/x-java"
     * @return non-null lookup result of MimeLookupInitializer(s).
     *  <br/>
     *  Typically there should be just one child initializer although if there
     *  will be more than one all of them will be taken into consideration.
     *  <br/>
     *  If there will be no specific initializers for the particular mime-type
     *  then an empty result should be returned.
     */
    public Lookup.Result child (String mimeType) {
        synchronized (children){
            String[] newMimeType = new String [mimeTypes.length + 1];
            System.arraycopy (mimeTypes, 0, newMimeType, 0, mimeTypes.length);
            newMimeType [mimeTypes.length] = mimeType;
            Lookup.Result child = (Lookup.Result) children.get(newMimeType);
            if (child == null){
                child = Lookups.fixed (
                    new Object[] {
                        new MimeLookupInitializerImpl (newMimeType)
                    }).lookup (
                        new Lookup.Template (MimeLookupInitializerImpl.class)
                    );
                children.put (newMimeType, child);
            }
            return child;
        }
    }
    
    private Lookup lookup;
    private Lookup _lookup () {
        if (lookup == null) {
            if (mimeTypes.length == 0){
                lookup  = Lookup.EMPTY;
                return lookup;
            }
            boolean testLookup = (mimeTypes.length > 0 && mimeTypes [0].startsWith ("test")); //NOI18N
            if (testLookup){
                lookup = new MyLookup (new Factory[] {
                    (Factory)EditorSettings.getDefault ().getFontColorSettings (mimeTypes)                });
            } else {
                lookup = new MyLookup (new Factory[] {
                    (Factory)EditorSettings.getDefault ().getFontColorSettings (mimeTypes),
                    (Factory)EditorSettings.getDefault ().getKeyBindingSettings (mimeTypes)
                });
            }
            if (testLookup) {
                String[] newMT = new String [mimeTypes.length];
                System.arraycopy (mimeTypes, 0, newMT, 0, newMT.length);
                int i = mimeTypes [0].indexOf ('_');
                if (i < 0) throw new IllegalArgumentException ("Wrong mimetype name:" + mimeTypes [0]);
                newMT [0] = mimeTypes [0].substring (i + 1);
                lookup = new OldProxyLookup (new Lookup[] {
                    lookup,
                    Lookups.exclude (
                        getMimeLookup (newMT), 
                        new Class[] {
                            FontColorSettingsImpl.class,
                            KeyBindingSettingsImpl.class
                        }
                    )
                });
            }
        }
        return lookup;
    }
    
    private static Lookup getMimeLookup (String[] mimeTypes) {
        if (mimeTypes.length < 1) return Lookup.EMPTY;
        MimeLookup mimeLookup = MimeLookup.getMimeLookup (mimeTypes [0]);
        int i, k = mimeTypes.length;
        for (i = 1; i < k; i++)
            mimeLookup = mimeLookup.childLookup (mimeTypes [i]);
        return mimeLookup;
    }

    interface Factory {
        void addPropertyChangeListener (PropertyChangeListener l);
        Object createInstance();
    }
    
    
    private class MyLookup extends AbstractLookup implements PropertyChangeListener {
        private Factory[] factories;
        private Object[] instances;
        private InstanceContent ic;
        private List removedInstances;
        
        public MyLookup(Factory[] factories) {
            this(factories, new InstanceContent());
        }
        
        private MyLookup(Factory[] factories, InstanceContent ic) {
            super(ic);
            this.ic = ic;
            this.factories = factories;
            this.instances = new Object[factories.length];
        }
        
        protected void initialize() {
            for (int i = 0; i < factories.length; i++) {
                instances[i] = factories[i].createInstance();
            }
            update();
            for (int i = 0; i < factories.length; i++) {
                factories[i].addPropertyChangeListener(this);
            }
        }
        
        private void update() {
            ArrayList arr = new ArrayList();
            arr.addAll(Arrays.asList(this.instances));
            ic.set(arr, null);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Factory f = (Factory)evt.getSource();
            for (int i = 0; ; i++) {
                if (this.factories[i] == f) {
                    this.instances[i] = f.createInstance();
                    assert instances[i] != null;
                    update();
                    return;
                }
            }
        }
    }
    
    
}
