/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.settings.storage;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;


/**
 * This class contains support static methods for loading / saving and 
 * translating coloring (fontsColors.xml) files. It calls XMLStorage utilities.
 *
 * @author Jan Jancura
 */
class SimpleAttributeSet implements AttributeSet {

    private Hashtable map = new Hashtable ();
    private AttributeSet parent;


    SimpleAttributeSet () {
    }
    
    SimpleAttributeSet (AttributeSet as) {
        Enumeration names = as.getAttributeNames ();
        while (names.hasMoreElements ()) {
            Object name = names.nextElement ();
            map.put (name, as.getAttribute (name));
        }
        parent = as.getResolveParent ();
        if (parent != null)
            parent = new SimpleAttributeSet (parent);
    }

    public boolean containsAttribute (Object name, Object value) {
        return map.containsKey (name) &&
               map.get (name).equals (value);
    }

    public boolean containsAttributes (AttributeSet as) {
        Enumeration names = as.getAttributeNames ();
        while (names.hasMoreElements ()) {
            Object name = names.nextElement ();
            if (!containsAttribute (name, as.getAttribute (name))) 
                return false;
        }
        return true;
    }

    public AttributeSet copyAttributes () {
        return new SimpleAttributeSet (this);
    }

    public Object getAttribute (Object name) {
        return map.get (name);
    }

    public int getAttributeCount () {
        return map.size ();
    }

    public Enumeration getAttributeNames () {
        return map.keys ();
    }

    public AttributeSet getResolveParent () {
        return parent;
    }

    public boolean isDefined (Object name) {
        return map.containsKey (name);
    }

    public boolean isEqual (AttributeSet as) {
        return ((getAttributeCount () == as.getAttributeCount ()) &&
                containsAttributes (as));
    }
    
    void addAttribute (Object name, Object value) {
        map.put (name, value);
    }
    
    public String toString () {
        return super.toString () + " " + map.toString ();
    }
}
