/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/** Testing basic functionality of Editor Settings Storage friend API
 * 
 *  @author Martin Roskanin
 */
public class EditorSettingsStorageTestBase extends NbTestCase {

    protected final int resultChangedCount[] = new int[1];
    protected static final int WAIT_TIME_FIRING = 1500;    
    
    public EditorSettingsStorageTestBase(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
    
        EditorTestLookup.setLookup(
                getWorkDir(),
            new URL[] {
                getClass().getClassLoader().getResource(
                        "org/netbeans/modules/defaults/mf-layer.xml"),
                getClass().getClassLoader().getResource(
                        "org/netbeans/modules/java/editor/resources/layer.xml"),
            },
            new Object[] {},
            getClass().getClassLoader()
        );
    }


    
    protected AttributeSet getSetting(String mime, String settingName){
        MimeLookup mimelookup = MimeLookup.getMimeLookup(mime);
        FontColorSettings fcs = (FontColorSettings) mimelookup.lookup(FontColorSettings.class);
        return fcs.getTokenFontColors(settingName);
    }
    
    protected void setSetting(String mime, String settingName, AttributeSet set){
        setSetting(mime, settingName, set, false);
    }

    protected void setSetting(String mime, String settingName, AttributeSet set, boolean checkValueSetting){
        EditorSettings editorSettings = EditorSettings.getDefault ();
        MimeLookup mimelookup = MimeLookup.getMimeLookup(mime);
        FontColorSettings fcs = (FontColorSettings) mimelookup.lookup(FontColorSettings.class);
       
        FontColorSettings fcsStorage = 
                (FontColorSettings) mimelookup.lookup(FontColorSettings.class);

        List colors = new ArrayList();
        colors.add(set);
        String types[] = new String[]{"text/x-java"};        
        FontColorSettingsFactory fcsImpl = 
                EditorSettingsImpl.getDefault().getFontColorSettings(types);
        
        fcsImpl.setAllFontColors (
            editorSettings.getCurrentFontColorProfile (),
            colors
        );
        
        // test setting was really set
        if (checkValueSetting){
            assertTrue(set.equals(getSetting(mime, settingName)));
        }
        
    }
    
    protected void checkResultChange(final int count) throws IOException{
        // wait for firing event
        SettingsStorageTestUtils.waitMaxMilisForValue(WAIT_TIME_FIRING, new SettingsStorageTestUtils.ValueResolver(){
            public Object getValue(){
                return Boolean.FALSE;
            }
        }, Boolean.TRUE);
        assertTrue(("resultChangedCount is:"+resultChangedCount[0]+" instead of "+count), resultChangedCount[0] == count);
    }

}
