/*
 * PropertiesDialog.java
 *
 * Created on November 15, 2002, 7:10 PM
 */

package org.netbeans.test.editor.app.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.netbeans.test.editor.app.Main;
import org.netbeans.test.editor.app.core.properties.ArrayProperty;
import org.netbeans.test.editor.app.core.properties.BadPropertyNameException;
import org.netbeans.test.editor.app.core.properties.Properties;
import org.netbeans.test.editor.app.core.Test;
import org.netbeans.test.editor.app.core.TestCallAction;
import org.netbeans.test.editor.app.core.TestLogAction;
import org.netbeans.test.editor.app.core.TestNode;
import org.netbeans.test.editor.app.core.TestSetIEAction;
import org.netbeans.test.editor.app.core.TestSetKitAction;
import org.netbeans.test.editor.app.core.TestStringAction;
import org.netbeans.test.editor.app.core.XMLNode;
import org.netbeans.test.editor.app.core.properties.StringProperty;
import org.netbeans.test.editor.app.gui.QuestionDialog;

/**
 *
 * @author  eh103527
 */
public class PropertiesDialog extends javax.swing.JDialog implements PropertyChangeListener {
    
    XMLNode node;
    static Hashtable lines=new Hashtable();
    
    String oldString;
    
    /** Creates new form PropertiesDialog */
    public PropertiesDialog(java.awt.Frame parent, XMLNode n) {
        super(parent, false);
        this.node=n;
        node.addPropertyChangeListener(this);
        initComponents();
        oldString=node.toString();
        setTitle(getTitle()+" ["+node+"]");
        generateButtons();
        pack();
        setSize(PropertiesDialog.PropertyLine.WIDTH*2+64,PropertiesDialog.PropertyLine.HEIGHT*(leftPanel.getComponentCount()+2));
        splitPane.setDividerLocation((getWidth()/7)*3);
        setLocation(parent.getX(),parent.getY()+parent.getHeight()-getHeight());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        splitPane = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        leftPanel = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        rightPanel = new javax.swing.JPanel();

        setTitle("Properties");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        splitPane.setDividerLocation(0);
        splitPane.setDividerSize(4);
        splitPane.setResizeWeight(1.0);
        splitPane.setPreferredSize(new java.awt.Dimension(100, 100));
        jPanel1.setLayout(new java.awt.BorderLayout());

        leftPanel.setLayout(new java.awt.GridLayout(1, 1));

        jPanel1.add(leftPanel, java.awt.BorderLayout.CENTER);

        splitPane.setLeftComponent(jPanel1);

        jPanel2.setLayout(new java.awt.BorderLayout());

        rightPanel.setLayout(new java.awt.GridLayout(1, 1));

        jPanel2.add(rightPanel, java.awt.BorderLayout.CENTER);

        splitPane.setRightComponent(jPanel2);

        jScrollPane1.setViewportView(splitPane);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        node.removePropertyChangeListener(this);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new PropertiesDialog(new javax.swing.JFrame(), new TestStringAction("Aaaa","a")).show();
    }
    
    private void generateButtons() {
        try {
            Properties ps=node.getProperties();
            int rows=1;
            PropertyLine line;
            String propertyName;
            
            //Type read-only line
            propertyName="Type";
            String type=node.getClass().getName();
            type=type.substring(type.lastIndexOf('.')+1);
            line=getPropertyLine(propertyName,new StringProperty(type),true);
            leftPanel.add(line.button);
            rightPanel.add(line.panel);
            line.panel.setDialog(this);
            //END of type section
            
            for (Enumeration en=ps.propertyNames();en.hasMoreElements();) {
                rows++;
                ((GridLayout)(leftPanel.getLayout())).setRows(rows);
                ((GridLayout)(rightPanel.getLayout())).setRows(rows);
                propertyName=(String)(en.nextElement());
                line=getPropertyLine(propertyName,ps.getProperty(propertyName));
                leftPanel.add(line.button);
                rightPanel.add(line.panel);
                line.panel.setDialog(this);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public void buttonPressed(java.awt.event.ActionEvent evt) {  //unselect all except selected
        Component[] cs=rightPanel.getComponents();
        for (int i=0;i < cs.length;i++) {
            if (!evt.getSource().equals(cs[i])) {
                ((PropertyPanel)(cs[i])).setState(true);
            }
        }
    }
    
    public PropertyLine getPropertyLine(String propertyName,Object value) {
        PropertyLine ret;
        ret=new PropertiesDialog.PropertyLine(propertyName,value);
        lines.put(propertyName,ret);
        return ret;
    }
    
    public PropertyLine getPropertyLine(String propertyName,Object value,boolean readOnly) {
        PropertyLine ret;
        ret=new PropertiesDialog.PropertyLine(propertyName,value,readOnly);
        lines.put(propertyName,ret);
        return ret;
    }
    
    public void propertyChanged(String property,Object value) {
        try {
            node.setProperty(property, value);
        } catch (BadPropertyNameException ex) {
            QuestionDialog dlg=new QuestionDialog(Main.frame,ex.getMessage());
            dlg.show();
        }
    }
    
    /** This method gets called when a bound property is changed.
     * @param evt A PropertyChangeEvent object describing the event source
     *   	and the property that has changed.
     *
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (oldString.compareTo(node.toString()) != 0) {
            oldString=node.toString();
            setTitle("Properties ["+oldString+"]");
        }
        Properties ps=node.getProperties();
        Component[] csl=leftPanel.getComponents();
        Component[] csr=rightPanel.getComponents();
        for (int i=1;i < csl.length;i++) {  //first element is a Type
            String s=((JButton)csl[i]).getText();
            Object o=ps.getProperty(s);
            ((PropertyPanel)(csr[i])).setProperty(o);
        }
    }
    
    static class PropertyLine {
        
        public static int HEIGHT=24;
        public static int WIDTH=132;
        
        public JButton button;
        public PropertyPanel panel;
        
        public PropertyLine(String name,Object data) {
            if (data instanceof ArrayProperty) {
                panel=new ArrayPropertyPanel((ArrayProperty)data,name);
            } else {
                panel=new PropertyPanel(data,name);
            }
            panel.setSize(WIDTH,HEIGHT);
            button=new JButton(name);
            button.setSize(WIDTH,HEIGHT);
            button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent ev) {
                    panel.changeState(ev);
                }
            });
        }
        
        public PropertyLine(String name,Object data,boolean readOnly) {
            button=new JButton(name);
            button.setSize(WIDTH,HEIGHT);
            button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent ev) {
                    panel.changeState(ev);
                }
            });
            panel=new PropertyPanel(data,name,readOnly);
            panel.setSize(WIDTH,HEIGHT);
        }
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel leftPanel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSplitPane splitPane;
    private javax.swing.JPanel rightPanel;
    // End of variables declaration//GEN-END:variables
    
}
