/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext.html;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.test.TestBase;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.editor.html.HTMLKit;
import org.netbeans.modules.editor.html.NbReaderProvider;

import org.openide.ErrorManager;

/**Html syntax support tests
 * This class extends TestBase class which provides access to the html editor module layer
 *
 * @author Marek Fukala
 */
public class HTMLSyntaxSupportTest extends TestBase {
    
    static HTMLSyntaxSupport sup;
    static BaseDocument doc;
    
    public HTMLSyntaxSupportTest() throws IOException, BadLocationException {
        super("htmlsyntaxsupporttest");
        setUpSuite();
    }
    
    private void setUpSuite() throws IOException, BadLocationException {
        File inputFile = new File(getDataDir(), "input/HTMLSyntaxSupportTest/index.html");
        String content = Utils.readFileContentToString(inputFile);
        doc = new BaseDocument(HTMLKit.class, false);
        doc.insertString(0,content,null);
        sup = new HTMLSyntaxSupport(doc);
        
        NbReaderProvider.setupReaders(); //initialize DTD providers
    }
    
    public void tearDown() {
    }
    
    //test methods -----------
    
    public void testBasis() {
        assertNotNull(sup.getDocument());
        assertEquals(sup.getDocument(), doc);
        
        assertNotNull(sup.getDocType());
        assertEquals("-//W3C//DTD HTML 4.01 Transitional//EN", sup.getDocType());
        
        DTD dtd = sup.getDTD();
        assertNotNull(dtd);
    }
    
    public void testSyntaxElementsBasis() throws BadLocationException {
        SyntaxElement se = sup.getElementChain(0);
        
        assertNotNull(se);
        assertNull(se.getPrevious()); //there shouldn't be any element before
        
        SyntaxElement next = se.getNext();
        assertNotNull(next);
        
        SyntaxElement prev = next.getPrevious();
        assertNotNull(next);
        assertEquals(prev, se);
    }
    
    
    public void testSyntaxElementsForEveryPositionInDocument() throws BadLocationException {
        for(int i = 0; i < doc.getLength(); i++) {
            SyntaxElement se = sup.getElementChain(i);
            assertNotNull(se);
            getRef().println(i+":"+se);
        }
        compareReferenceFiles();
    }
    
    public void testWalkThroughSyntaxElements() throws BadLocationException {
        SyntaxElement se = sup.getElementChain(0);
        do {
            getRef().println(se);
            
            SyntaxElement next = se.getNext();
            
            assertNotSame(next, se);
            se = next;
        } while(se != null);
        
        compareReferenceFiles();
    }
    
    public void testWalkBackwartThroughtSyntaxElements() throws BadLocationException {
        SyntaxElement se = sup.getElementChain(doc.getLength() - 1);
        do {
            getRef().println(se);
            
            SyntaxElement prev = se.getPrevious();
            
            assertNotSame(prev, se);
            se = prev;
        } while(se != null);
        
        compareReferenceFiles();
    }
    
    public void testIsSingletonTag() throws BadLocationException {
        HTMLSyntaxSupport sup = createSupportForText(TEXT1);
        
        //test the <html> tag
        int htmlTagOffset = 2;
        TokenItem ti = sup.getTokenChain(htmlTagOffset, htmlTagOffset+1);
        assertNotNull(ti);
        assertFalse(sup.isSingletonTag(ti));
        
        //test the <br/> tag
        htmlTagOffset = 35;
        ti = sup.getTokenChain(htmlTagOffset, htmlTagOffset+1);
        assertNotNull(ti);
        assertTrue(sup.isSingletonTag(ti));
    }
    
    public void testFindMatchingBlock() throws BadLocationException {
        for(int i = 0; i < doc.getLength(); i++) {
            int[] match = sup.findMatchingBlock(i, false);
            if(match == null) {
                getRef().println(i + " => NO MATCH");
            } else {
                getRef().println(i + " => " + "[" + match[0] + ";" + match[1] + "]");
            }
        }
        
        compareReferenceFiles();
    }
    
    private static HTMLSyntaxSupport createSupportForText(String text) throws BadLocationException {
        BaseDocument bd = new BaseDocument(HTMLKit.class, false);
        bd.insertString(0,text,null);
        return new HTMLSyntaxSupport(bd);
    }
    
    //                                   0         1         2         3         4         
    //                                   01234567890123456789012345678901234567890123456789
    private static final String TEXT1 = "<html><body bgcolor=\"green\">hello<br/></body></html>";
    
}
