/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.html.editor.options;

import org.netbeans.modules.editor.html.HTMLKit;
import org.netbeans.modules.editor.options.BasePrintOptions;

/**
* Options for the java editor kit
*
* @author Miloslav Metelka
* @version 1.00
*/
public class HTMLPrintOptions extends BasePrintOptions {

    public static final String HTML = "html"; // NOI18N

    static final long serialVersionUID =5891998739446259286L;

    public HTMLPrintOptions() {
        this(HTMLKit.class, HTML);
    }

    public HTMLPrintOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
    }

    /**
     * Get localized string
     */
    protected String getString(String key) {
        try {
            return org.openide.util.NbBundle.getMessage(HTMLOptions.class, key);
        } catch (java.util.MissingResourceException e) {
            return super.getString(key);
        }
    }

}
