/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.html.editor.folding;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.editor.html.HTMLKit;
import org.netbeans.modules.html.editor.folding.HTMLFoldManager.FoldInfo;
import org.netbeans.modules.html.editor.test.Utils;
 
/** HTML Folding unit tests
 *
 * @author  Marek Fukala
 */
public class HTMLFoldingTest extends NbTestCase {
    
    private HTMLFoldManager fm;
    
    public HTMLFoldingTest() {
        super("html-folding-test");
         fm = new HTMLFoldManager();
         fm.documentDirty = false;
    }
    
    //--------- test methods -----------
    public void testModelBasis() throws Exception /*BadLocationException, ParsingCancelledException*/ {
        //set the document content
        BaseDocument doc = new BaseDocument(HTMLKit.class, false);
        HTMLSyntaxSupport sup = new HTMLSyntaxSupport(doc);
        
        doc.insertString(0,"\n  <b>\n ahoj\n </b>\n  ",null); //4 elements should be created
        List/*<FoldInfo>*/ fis = fm.generateFolds(sup);
        
        assertEquals(1, fis.size()); //one fold for <b></b> created
        
        //dumpFoldInfos(fis);
    }
     
    public void testIndexHtml() throws Exception {
        testFolds(new File(getDataDir(), "input/HTMLFoldingTest/index.html"));
    }
    
    private void testFolds(File inputFile) throws IOException, BadLocationException, HTMLFoldManager.ParsingCancelledException {
        String content = Utils.readFileContentToString(inputFile);
        BaseDocument doc = new BaseDocument(HTMLKit.class, false);
        doc.insertString(0,content,null);
        HTMLSyntaxSupport sup = new HTMLSyntaxSupport(doc);
        
        List/*<FoldInfo>*/ fis = fm.generateFolds(sup);
        dumpFoldInfos(fis);
        
        compareReferenceFiles();
    }
    
    private void dumpFoldInfos(List/*<FoldInfo>*/ foldInfos) {
        Iterator i = foldInfos.iterator();
        while(i.hasNext()) {
            FoldInfo fi = (FoldInfo)i.next();
            getRef().println(fi);
        }
    }
    
}
