/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javascript.editor.options;

import java.util.MissingResourceException;
import org.netbeans.editor.SettingsNames;
import org.netbeans.editor.ext.ExtSettingsNames;
import org.netbeans.modules.editor.SimpleIndentEngine;
//import org.netbeans.editor.ext.html.HTMLSettingsNames;
//import org.netbeans.modules.editor.html.HTMLKit;
//import org.netbeans.modules.editor.html.HTMLIndentEngine;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.javascript.editor.syntax.JSKit;
import org.openide.util.HelpCtx;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.NbBundle;
import java.awt.Color;
import java.awt.Dimension;

/**
* Options for the javascript editor kit
*
* @author Marek Fukala
* @version 1.00
*/ 
public class JSOptions extends BaseOptions {
    
    private static final String HELP_ID = "editing.editor.javascript"; // !!! NOI18N
    
    static final String[] JS_PROP_NAMES = OptionSupport.mergeStringArrays(BaseOptions.BASE_PROP_NAMES, new String[] {});
                                        
    static final long serialVersionUID = 75289734362748537L;//FIXME
   
    public JSOptions() {
        super(JSKit.class, "javascript");
    }

    protected Class getDefaultIndentEngineClass() {                             
	return SimpleIndentEngine.class;                                          
    }

    public HelpCtx getHelpCtx () {
        return new HelpCtx (HELP_ID);
    }

    /**
     * Get localized string
     */
    protected String getString(String key) {
        try {
            return NbBundle.getMessage(JSOptions.class, key);
        } catch (MissingResourceException e) {
            return super.getString(key);
        }
    }

}
