package org.netbeans.modules.javascript.loaders;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class JSDataLoader extends UniFileLoader {
    
    public static final String REQUIRED_MIME = "text/x-javascript";
    
    private static final long serialVersionUID = 1L;
    
    public JSDataLoader() {
        super("org.netbeans.modules.javascript.loaders.JSDataObject");
    }
    
    protected String defaultDisplayName() {
        return NbBundle.getMessage(JSDataLoader.class, "LBL_JS_loader_name");
    }
    
    protected void initialize() {
        super.initialize();
        getExtensions().addMimeType(REQUIRED_MIME);
    }
    
    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new JSDataObject(primaryFile, this);
    }
    
    protected String actionsContext() {
        return "Loaders/" + REQUIRED_MIME + "/Actions";
    }
    
}
