package org.netbeans.modules.javascript.loaders;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;

public class JSDataObject extends MultiDataObject {
    
    transient private JSEditorSupport editorSupport;
    
    public JSDataObject(FileObject pf, JSDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet cookies = getCookieSet();
        //cookies.add((Node.Cookie) DataEditorSupport.create(this, getPrimaryEntry(), cookies));
    }
    
   public Node.Cookie getCookie(Class type) {
        if (type.isAssignableFrom(JSEditorSupport.class)) {
            return getJSEditorSupport();
        }
        return super.getCookie(type);
    }
    
   private synchronized JSEditorSupport getJSEditorSupport() {
        if (editorSupport == null) {
            editorSupport = new JSEditorSupport(this);
        }
        return editorSupport;
    }
    
    protected Node createNodeDelegate() {
        return new JSDataNode(this);
    }
    
}
