/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.httpserver;

import org.openide.actions.PropertiesAction;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;

/** Proxy to HTTP server that allows to start/stop it from Runtime tab.
 *
 * @author Radim Kubacki
 */
public class HttpServerNode extends FilterNode {
    
    public HttpServerNode() throws DataObjectNotFoundException {
        this (DataObject.find(
            Repository.getDefault().getDefaultFileSystem().findResource("Services/org-netbeans-modules-httpserver-HttpServerSettings.settings") // NOI18N
            ).getNodeDelegate()
        );
    }
    
    public HttpServerNode(Node original) {
        super(original, Children.LEAF);
    }
    
    public Node cloneNode() {
        // Usually you will want to override this if you are subclassing.
        // Otherwise a filter of a filter is created, which works but is not ideal.
        return new HttpServerNode(getOriginal());
    }
    
    /** Enhances original settings with Start and Stop action.
     * @return system actions appropriate to the node
     */
    public SystemAction[] getActions() {
        return new SystemAction [] {
            SystemAction.get(StartHttpServerAction.class),
            SystemAction.get(StopHttpServerAction.class),
            null,
            SystemAction.get(PropertiesAction.class)
        };
    }
    
    /** Adds helpIDs to node */
    public org.openide.nodes.Node.PropertySet[] getPropertySets () {
        PropertySet[] ps = super.getPropertySets ();
        for (int i = 0; i< ps.length; i++) {
            if (Sheet.PROPERTIES.equals (ps[i].getName ())) {
                ps[i].setValue ("helpID", HttpServerNode.class.getName ()+"_properties");   // NOI18N
            }
            else if (Sheet.EXPERT.equals (ps[i].getName ())) {
                ps[i].setValue ("helpID", HttpServerNode.class.getName ()+"_expert");   // NOI18N
            }
        }
        return ps;
    }
    
}
