/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.httpserver;

import javax.swing.Action;

import org.openide.NotifyDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

/** Action that starts internal HTTP server for the IDE.
 *
 * @author  Radim Kubacki
 */
public class StartHttpServerAction extends CallableSystemAction {
    
    public void performAction () {
        HttpServerSettings s = HttpServerModule.httpserverSettings ();
        if (s.isRunning ()) {
            DialogDisplayer.getDefault ().notify (
                new NotifyDescriptor.Message (
                    NbBundle.getMessage (StartHttpServerAction.class, "MSG_ServerAlreadyRunning"), 
                    NotifyDescriptor.INFORMATION_MESSAGE
                )
            );
        }
        else {
            s.setRunning (true);
        }
    }
    
    public String getName () {
        return NbBundle.getMessage (StartHttpServerAction.class, "LBL_StartHttpServerAction");
    }
    
    /*
    protected String iconResource () {
        return "org/netbeans/modules/httpserver/StartHttpServerActionIcon.gif";
    }
     */
    
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
        // return new HelpCtx (StartHttpServerAction.class);
    }
    
    /** Perform extra initialization of this action's singleton.
     */
    protected void initialize () {
        super.initialize ();
        putProperty (Action.SHORT_DESCRIPTION, NbBundle.getMessage (StartHttpServerAction.class, "HINT_StartHttpServerAction"));
    }

    protected boolean asynchronous() {
        return false;
    }
}
