/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.projectimport.jbuilder;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.projectimport.j2seimport.ui.BasicWizardIterator;
import org.netbeans.modules.projectimport.j2seimport.ui.ProgressPanel;
import org.netbeans.modules.projectimport.j2seimport.ui.WarningMessage;
import org.netbeans.modules.projectimport.jbuilder.ui.JBWizardData;
import org.netbeans.modules.projectimport.jbuilder.ui.JBuilderWizardIterator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.netbeans.modules.projectimport.j2seimport.ImportProcess;
import org.netbeans.modules.projectimport.j2seimport.ImportUtils;
import org.netbeans.modules.projectimport.j2seimport.ui.WizardSupport;

/**
 * Runs JBuilder Importer.
 *
 * @author Radek Matous
 */
public class ImportAction extends CallableSystemAction {
    private BasicWizardIterator wizardIterator;    
    public ImportAction() {
        putValue("noIconInMenu", Boolean.TRUE); //NOI18N
    }
    
    public void performAction() {
        try {
            JBWizardData wizardData = showWizard();
            if (wizardData != null) {
                performImport(wizardData);
            }
        } catch (Throwable thr) {
            ErrorManager.getDefault().notify(thr);
        }
    }

    private JBWizardData showWizard() {
        if (wizardIterator == null) {
            wizardIterator = JBuilderWizardIterator.createIterator();                
        }
        wizardIterator.setData(new JBWizardData()); 
        return (JBWizardData)WizardSupport.show(wizardIterator);
    }

    private void performImport(final JBWizardData wizardData) throws IOException {
        ImportProcess iProcess;
        FileObject prjDir = createFolder(wizardData.getDestinationDir());
        assert prjDir != null;

        iProcess = ImportUtils.createImportProcess(prjDir,wizardData.getProjectDefinition(),
                wizardData.isIncludeDependencies());

        ProgressPanel.showProgress(iProcess);
        WarningMessage.showMessages(iProcess);
        OpenProjects.getDefault().open(iProcess.getProjectsToOpen(), true);
    }
    

    private static FileObject createFolder (final File folder) throws IOException {
        FileObject retval = null;
        File root = getRoot(folder);
        if (!root.exists()) {
            throw new IOException(folder.getAbsolutePath());
        }
        FileObject rootFo = FileUtil.toFileObject(root);
        assert rootFo != null : root.getAbsolutePath();
        final String relativePath = getRelativePath(root, folder);                                
        try {
            retval = FileUtil.createFolder(rootFo,relativePath);        
        } catch (IOException ex) {
            //thus retval = null;
        }
        //if refresh needed because of external changes
        if (retval == null || !retval.isValid()) {
            rootFo.getFileSystem().refresh(false);
            retval = FileUtil.createFolder(rootFo,relativePath);
        }        
        assert retval != null;        
        return retval;
    } 
    
    private static File getRoot(final File dir) {
        File retval = dir;        
        for (; retval.getParentFile() != null; retval = retval.getParentFile());
        assert retval != null;
        return retval;
    }
    
    private static String getRelativePath(final File dir, final File file) {
        Stack stack = new Stack ();                
        File tempFile = file;
        while(tempFile != null && !tempFile.equals(dir)) {
            stack.push (tempFile.getName());
            tempFile = tempFile.getParentFile();
        }
        assert tempFile != null : file.getAbsolutePath() + "not found in " + dir.getAbsolutePath();//NOI18N
        StringBuffer retval = new StringBuffer();
        while (!stack.isEmpty()) {
            retval.append((String)stack.pop());
            if (!stack.isEmpty()) {
                retval.append('/');
            }
        }                        
        return retval.toString();
    }
    
    public String getName() {
        return NbBundle.getMessage(ImportAction.class, "CTL_MenuItem"); // NOI18N
    }
    
    public HelpCtx getHelpCtx() {
        return null;
    }
    
    protected boolean asynchronous() {
        return false;
    }
    
}
