/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package validation;

import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.junit.NbTestSuite;

/**
 * Overall sanity check suite for IDE before commit.<br>
 * Look at IDEValidation.java for test specification and implementation.
 *
 * @author Jiri.Skrivanek@sun.com
 */
public class IDECommitValidation extends JellyTestCase {
    
    
    /** Need to be defined because of JUnit */
    public IDECommitValidation(String name) {
        super(name);
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        // #67377 - not run on Mac because it fails
        if(System.getProperty("os.name").toLowerCase().indexOf("mac") == -1) { // NOI18N
            suite.addTest(new IDEValidation("testMainMenu"));
            //suite.addTest(new IDEValidation("testHelp"));
            suite.addTest(new IDEValidation("testOptions"));
            suite.addTest(new IDEValidation("testNewProject"));
            // sample project must exist before testShortcuts
            suite.addTest(new IDEValidation("testShortcuts"));
            suite.addTest(new IDEValidation("testNewFile"));
            suite.addTest(new IDEValidation("testCVSLite"));
            suite.addTest(new IDEValidation("testProjectsView"));
            suite.addTest(new IDEValidation("testFilesView"));
            suite.addTest(new IDEValidation("testEditor"));
            suite.addTest(new IDEValidation("testBuildAndRun"));
            suite.addTest(new IDEValidation("testDebugging"));
            suite.addTest(new IDEValidation("testJUnit"));
            suite.addTest(new IDEValidation("testXML"));
            suite.addTest(new IDEValidation("testWebApplication"));
            // not in commit suite because it needs net connectivity
            //suite.addTest(new IDEValidation("testUpdateCenter"));
            suite.addTest(new IDEValidation("testDb"));
            suite.addTest(new IDEValidation("testWindowSystem"));
            suite.addTest(new IDEValidation("testSeparateWindowsMode"));
            suite.addTest(new IDEValidation("testModuleInstallation"));
        }
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        junit.textui.TestRunner.run(suite());
        // run only selected test case
        //junit.textui.TestRunner.run(new IDEValidation("testMainMenu"));
    }
}
