/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package validation;

import java.lang.reflect.Method;
import org.netbeans.junit.NbTestCase;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;

/**
 * test for reflection used in multiview module that retrieves a setting value from editor.
 *
 * @author mkleint
 */
public class MultiviewEditorReflectionTest extends NbTestCase {
    
    /** Creates a new instance of MultiviewEditorReflectionTest */
    public MultiviewEditorReflectionTest(String name) {
        super(name);
    }
    
    public void testReflection() throws Exception {
            final ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class settingsClass = Class.forName(
                    "org.netbeans.editor.Settings", false, loader); //NOI18N
            Class listenerClass = Class.forName(
                    "org.netbeans.editor.SettingsChangeListener", false, loader); //NOI18N
            Method addSettingsListener = settingsClass.getMethod(
                    "addSettingsChangeListener",new Class[ ] { listenerClass });//NOI18N
            Method removeSettingsListener = settingsClass.getMethod(
                    "removeSettingsChangeListener",new Class[ ] { listenerClass });//NOI18N

            Class editorBaseOption = Class.forName("org.netbeans.modules.editor.options.BaseOptions", true,
                    loader);
            SharedClassObject option = SharedClassObject.findObject(editorBaseOption);
            Method is = option.getClass().getMethod("isToolbarVisible", new Class[0]);
    }

}
