/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.welcome.ui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.netbeans.modules.welcome.content.BackgroundPainter;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.Utilities;

/**
 *
 * @author S. Aubrecht
 */
public class DefaultBackgroundPainter implements BackgroundPainter, Constants {
    
//    private ImageIcon background = new ImageIcon(Utilities.loadImage(BACKGROUND_IMAGE, true));    
    private ImageIcon top = new ImageIcon(Utilities.loadImage(BACKGROUND_TOP_IMAGE, true));
    private ImageIcon bottom = new ImageIcon(Utilities.loadImage(BACKGROUND_BOTTOM_IMAGE, true));

    /** Creates a new instance of DefaultBackgroundPainter */
    public DefaultBackgroundPainter() {
    }
    
    public void paintComponent( JComponent c, Graphics g ) {
        Graphics2D g2 = Utils.prepareGraphics( g );

        g2.setColor( Utils.getColor(SCREEN_BACKGROUND_COLOR) );
        g2.fillRect(0, 0, c.getWidth(), c.getHeight());
        
//        background.paintIcon(c, g2, 
//            (c.getWidth() - background.getIconWidth()) / 2, 
//            (c.getHeight() - background.getIconHeight()) / 2);
//
        g2.drawImage( top.getImage(), 0, 0, c.getWidth(), top.getIconHeight(), null );
        g2.drawImage( bottom.getImage(), 0, c.getHeight()-bottom.getIconHeight(),
                c.getWidth(), bottom.getIconHeight(), null );
    }
}
