/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.archive.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.netbeans.modules.j2ee.archive.project.*;
import org.netbeans.modules.j2ee.archive.ui.JavaEePlatformUiSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class DeployablePanelVisual extends JPanel implements DocumentListener, ActionListener {
    
    private transient DeployableWizardPanel panel;
    private static File savedArchiveLoc = null;
    
    /** Creates new form PanelProjectLocationVisual */
    public DeployablePanelVisual(DeployableWizardPanel panel) {
        initComponents();
        this.panel = panel;
        
        // Register listener on the textFields to make the automatic updates
        projectNameTextField.getDocument().addDocumentListener(this);
        projectLocationTextField.getDocument().addDocumentListener(this);
        archiveFileField.getDocument().addDocumentListener(this);
        serverInstanceComboBox.addActionListener(this);
    }
    
    
    public String getProjectName() {
        return this.projectNameTextField.getText();
    }
    
    private String validFreeProjectName(final File parentFolder, final String formater, final int index) {
        String name = MessageFormat.format(formater, new Object[]{new Integer(index)});
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        projectNameLabel = new javax.swing.JLabel();
        projectNameTextField = new javax.swing.JTextField();
        projectLocationLabel = new javax.swing.JLabel();
        projectLocationTextField = new javax.swing.JTextField();
        projectLocationButton = new javax.swing.JButton();
        createdFolderLabel = new javax.swing.JLabel();
        createdFolderTextField = new javax.swing.JTextField();
        archiveFileLabel = new javax.swing.JLabel();
        archiveFileField = new javax.swing.JTextField();
        archiveLocationButton = new javax.swing.JButton();
        targetServerLabel = new javax.swing.JLabel();
        serverInstanceComboBox = new javax.swing.JComboBox();
        manageServersButton = new javax.swing.JButton();

        projectNameLabel.setLabelFor(projectNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(projectNameLabel, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("projectName_TEXT"));

        projectLocationLabel.setLabelFor(projectLocationTextField);
        org.openide.awt.Mnemonics.setLocalizedText(projectLocationLabel, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("projectLocation_TEXT"));

        org.openide.awt.Mnemonics.setLocalizedText(projectLocationButton, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("browse_TEXT"));
        projectLocationButton.setActionCommand(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("BROWSE"));
        projectLocationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                projectLocationButtonActionPerformed(evt);
            }
        });

        createdFolderLabel.setLabelFor(createdFolderTextField);
        org.openide.awt.Mnemonics.setLocalizedText(createdFolderLabel, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("projectFolder_TEXT"));

        createdFolderTextField.setEditable(false);

        org.openide.awt.Mnemonics.setLocalizedText(archiveFileLabel, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("archiveFileLabel_TEXT"));

        org.openide.awt.Mnemonics.setLocalizedText(archiveLocationButton, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("browse_TEXT"));
        archiveLocationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                archiveLocationButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(targetServerLabel, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("targetServerLabel_TEXT"));

        serverInstanceComboBox.setModel(JavaEePlatformUiSupport.createPlatformComboBoxModel(null));

        org.openide.awt.Mnemonics.setLocalizedText(manageServersButton, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle").getString("LBL_ManageServers"));
        manageServersButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                manageServersButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(projectNameLabel)
                            .add(projectLocationLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 106, Short.MAX_VALUE)
                            .add(createdFolderLabel)
                            .add(archiveFileLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                    .add(layout.createSequentialGroup()
                        .add(targetServerLabel)
                        .add(33, 33, 33)))
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(serverInstanceComboBox, 0, 195, Short.MAX_VALUE)
                    .add(createdFolderTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, projectNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE)
                    .add(projectLocationTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, archiveFileField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(projectLocationButton)
                    .add(archiveLocationButton)
                    .add(manageServersButton))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(projectNameLabel)
                    .add(projectNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(projectLocationLabel)
                    .add(projectLocationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(projectLocationButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(createdFolderLabel)
                    .add(createdFolderTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(archiveFileLabel)
                    .add(archiveFileField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(archiveLocationButton))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(targetServerLabel)
                    .add(serverInstanceComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(manageServersButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void manageServersButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_manageServersButtonActionPerformed
        Object serverInstanceWrapper =  serverInstanceComboBox.getSelectedItem();
        String lastSelectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            lastSelectedServerInstanceID = JavaEePlatformUiSupport.getServerInstanceID(serverInstanceWrapper);
        }
        ServerManager.showCustomizer(lastSelectedServerInstanceID);
        serverInstanceComboBox.setModel(JavaEePlatformUiSupport.createPlatformComboBoxModel(lastSelectedServerInstanceID));
    }//GEN-LAST:event_manageServersButtonActionPerformed
    
    private void archiveLocationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_archiveLocationButtonActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(DeployablePanelVisual.class,
                "DLG_TITLE_ArchiveChooser"));   // NOI18N
        chooser.setFileFilter(new FileFilter() {
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String path = f.getAbsolutePath();
                return acceptableArchive(path);
            }
            public String getDescription() {
                return NbBundle.getMessage(DeployablePanelVisual.class,
                        "ARCHIVE_CHOOSER_DESCRIPTOR");  //NOI18N
            }
        });
        String path = this.archiveFileField.getText();
        if (path.length() > 0) {
            File f = new File(path);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            }
        } else if (savedArchiveLoc != null) {
            chooser.setCurrentDirectory(savedArchiveLoc);
        }
        if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            archiveFileField.setText(FileUtil.normalizeFile(projectDir).getAbsolutePath());
            savedArchiveLoc = projectDir.getParentFile();
        }
        panel.fireChangeEvent();
    }//GEN-LAST:event_archiveLocationButtonActionPerformed
    
    private void projectLocationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_projectLocationButtonActionPerformed
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(DeployablePanelVisual.class,
                "DLG_TITLE_FolderChooser"));    //NOI18N
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        String path = this.projectLocationTextField.getText();
        if (path.length() > 0) {
            File f = new File(path);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            }
        }
        if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            projectLocationTextField.setText(FileUtil.normalizeFile(projectDir).getAbsolutePath());
        }
        panel.fireChangeEvent();
    }//GEN-LAST:event_projectLocationButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField archiveFileField;
    private javax.swing.JLabel archiveFileLabel;
    private javax.swing.JButton archiveLocationButton;
    private javax.swing.JLabel createdFolderLabel;
    private javax.swing.JTextField createdFolderTextField;
    private javax.swing.JButton manageServersButton;
    private javax.swing.JButton projectLocationButton;
    private javax.swing.JLabel projectLocationLabel;
    private javax.swing.JTextField projectLocationTextField;
    private javax.swing.JLabel projectNameLabel;
    private javax.swing.JTextField projectNameTextField;
    private javax.swing.JComboBox serverInstanceComboBox;
    private javax.swing.JLabel targetServerLabel;
    // End of variables declaration//GEN-END:variables
    
    public void addNotify() {
        super.addNotify();
        //same problem as in 31086, initial focus on Cancel button
        projectNameTextField.requestFocus();
    }
    
    private static final String WP_eM = "WizardPanel_errorMessage"; //NOI18N
    
    private static final ResourceBundle bundle = NbBundle.getBundle(DeployablePanelVisual.class);
    
    boolean valid(WizardDescriptor wizardDescriptor) {
        if (projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty(WP_eM,
                    bundle.getString("ERR_valid_folder_name")); //NOI18N
            return false; // Display name not specified
        }
        File f = FileUtil.normalizeFile(new File(projectLocationTextField.getText()).getAbsoluteFile());
        if (!f.isDirectory()) {
            String message = bundle.getString("ERR_valid_path");    //NOI18N
            wizardDescriptor.putProperty(WP_eM, message);
            return false;
        }
        final File destFolder = FileUtil.normalizeFile(new File(createdFolderTextField.getText()).getAbsoluteFile());
        
        File projLoc = destFolder;
        while (projLoc != null && !projLoc.exists()) {
            projLoc = projLoc.getParentFile();
        }
        if (projLoc == null || !projLoc.canWrite()) {
            wizardDescriptor.putProperty(WP_eM,
                    bundle.getString("ERR_cannot_write_folder"));   // NOI18N
            return false;
        }
        
        if (FileUtil.toFileObject(projLoc) == null) {
            String message = bundle.getString("ERR_valid_path");    // NOI18N
            wizardDescriptor.putProperty(WP_eM, message);
            return false;
        }
        
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            // Folder exists and is not empty
            wizardDescriptor.putProperty(WP_eM,
                    bundle.getString("ERR_folder_not_empty"));  // NOI18N
            return false;
        }
        f = FileUtil.normalizeFile(new File(archiveFileField.getText()).getAbsoluteFile());
        if (!f.exists() || !f.isFile() || !f.canRead()) {
            String message = bundle.getString("ERR_invalid_archive");   // NOI18N
            wizardDescriptor.putProperty(WP_eM, message);
            return false;
        }
        if (serverInstanceComboBox.getItemCount() == 0) {
            String message = bundle.getString("ERR_no_possible_target");    // NOI18N
            wizardDescriptor.putProperty(WP_eM, message);
            return false;
        }
        if (serverInstanceComboBox.getSelectedItem() == null) {
            String message = bundle.getString("ERR_no_target"); // NOI18N
            wizardDescriptor.putProperty(WP_eM, message);
            return false;
        }
        
        // this may take a while to compute...
        //
        if (!acceptableArchive(f.getAbsoluteFile().getAbsolutePath(), wizardDescriptor)) {
            String message = bundle.getString("ERR_unsupported_archive"); // NOI18N
            wizardDescriptor.putProperty(WP_eM, message);
            return false;
        }
        wizardDescriptor.putProperty(WP_eM, "");                                // NOI18N
        return true;
    }
    
    boolean acceptableArchive(String aPath, WizardDescriptor d) {
        // do the easy test first
        boolean retVal = false;
        if (aPath.endsWith("war")) {    // NOI18N
            d.putProperty(DeployableWizardIterator.PROJECT_TYPE_PROP,
                    ArchiveProjectProperties.PROJECT_TYPE_VALUE_WAR);
            retVal = true;
        }
        if (aPath.endsWith("car")) {    // NOI18N
            d.putProperty(DeployableWizardIterator.PROJECT_TYPE_PROP,
                    ArchiveProjectProperties.PROJECT_TYPE_VALUE_CAR);
            retVal = true;
        }
        if (aPath.endsWith("rar")) {    // NOI18N
            d.putProperty(DeployableWizardIterator.PROJECT_TYPE_PROP,
                    ArchiveProjectProperties.PROJECT_TYPE_VALUE_RAR);
            retVal = true;
        }
        if (aPath.endsWith("ear")) {    // NOI18N
            d.putProperty(DeployableWizardIterator.PROJECT_TYPE_PROP,
                    ArchiveProjectProperties.PROJECT_TYPE_VALUE_EAR);
            retVal = true;
        }
        if (aPath.endsWith("jar")) {    // NOI18N
            d.putProperty(DeployableWizardIterator.PROJECT_TYPE_PROP,
                    ArchiveProjectProperties.PROJECT_TYPE_VALUE_UNKNOWN);
            retVal = true;
        }
        return retVal;
    }
    
    // if this is called on "next" we are golden here
    //
    void store(WizardDescriptor d) {
        String name = projectNameTextField.getText().trim();
        String folder = createdFolderTextField.getText().trim();
        
        d.putProperty(DeployableWizardIterator.PROJECT_DIR_PROP, new File(folder));
        d.putProperty(DeployableWizardIterator.PROJECT_NAME_PROP, name);
        d.putProperty(DeployableWizardIterator.PROJECT_TARGET_PROP, serverInstanceComboBox.getSelectedItem());
        d.putProperty(DeployableWizardIterator.PROJECT_ARCHIVE_PROP, new File(archiveFileField.getText().trim()));
    }
    
    void read(WizardDescriptor settings) {
        File projectLocation = (File) settings.getProperty(DeployableWizardIterator.PROJECT_DIR_PROP);
        if (projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory()) {
            projectLocation = ProjectChooser.getProjectsFolder();
        } else {
            projectLocation = projectLocation.getParentFile();
        }
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        
        String projectName = (String) settings.getProperty(DeployableWizardIterator.PROJECT_NAME_PROP);
        if(projectName == null) {
            int baseCount = 0;
            String formater = bundle.getString("TXT_DefaultProjectName");   // NOI18N
            while ((projectName=validFreeProjectName(projectLocation, formater, baseCount))==null)
                baseCount++;
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
    }
    
    void validate(WizardDescriptor d) throws WizardValidationException {
        // nothing to validate
    }
    
    // Implementation of DocumentListener --------------------------------------
    
    public void changedUpdate(DocumentEvent e) {
        updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            firePropertyChange(DeployableWizardIterator.PROJECT_NAME_PROP,null,this.projectNameTextField.getText());
        }
    }
    
    public void insertUpdate(DocumentEvent e) {
        updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            firePropertyChange(DeployableWizardIterator.PROJECT_NAME_PROP,null,
                    this.projectNameTextField.getText());
        }
    }
    
    public void removeUpdate(DocumentEvent e) {
        updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            firePropertyChange(DeployableWizardIterator.PROJECT_NAME_PROP,null,
                    this.projectNameTextField.getText());
        }
    }
    
    /** Handles changes in the Project name and project directory, */
    private void updateTexts(DocumentEvent e) {
        
        Document doc = e.getDocument();
        
        if (doc == projectNameTextField.getDocument() || doc == projectLocationTextField.getDocument()) {
            // Change in the project name
            
            String projectName = projectNameTextField.getText();
            String projectFolder = projectLocationTextField.getText();
            
            createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        panel.fireChangeEvent(); // Notify that the panel changed
    }
    
    public void actionPerformed(ActionEvent e) {
        panel.fireChangeEvent();
    }
    
    private boolean acceptableArchive(String aPath) {
        boolean retVal = false;
        if (aPath.endsWith("war")) {    // NOI18N
            retVal = true;
        }
        if (aPath.endsWith("car")) {    // NOI18N
            retVal = true;
        }
        if (aPath.endsWith("ear")) {    // NOI18N
            retVal = true;
        }
        if (aPath.endsWith("jar")) {    // NOI18N
            retVal = true;
        }
        if (aPath.endsWith("rar")) {    // NOI18N
            retVal = true;
        }
        return retVal;
    }
}
