/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.blueprints.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.j2ee.blueprints.catalog.SolutionsCatalog;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbcatalog;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbcategory;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbexample;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbsolution;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbwriteup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.filesystems.Repository;
import org.openide.cookies.InstanceCookie;
import javax.swing.Action;


/**
 * Browser for BluePrints Solutions Catalog Entries.
 *
 * The user can browse categories and articles, design documents and
 * launch a wizard to create new projects from a template.
 *
 * @author Mark Roth
 * @author Yutaka Yoshida
 * @author Ludo
 * @author Richard Gregor
 */
public class BluePrintsPanel extends javax.swing.JPanel {
    
    /** Creates new form TitlePanel */
    public BluePrintsPanel() {
        initComponents();
        initTabs();
        initComboBox();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPopupMenu1 = new javax.swing.JPopupMenu();
        titlePanel = new javax.swing.JPanel();
        sunLogoLbl = new javax.swing.JLabel();
        titleSubPnl = new javax.swing.JPanel();
        titleLbl = new AntialiasedJLabel();
        titleSubLbl = new AntialiasedJLabel();
        toolbarPanel = new javax.swing.JPanel();
        entryCbx = new javax.swing.JComboBox();
        tabbedPnl = new javax.swing.JTabbedPane();
        categoryPnl = new CategoryTab(this);
        solutionPnl = new SolutionTab(this);
        designPnl = new DesignTab(this);
        examplePnl = new ExampleTab(this);
        homePnl = new HomeTab(this);

        setLayout(new java.awt.GridBagLayout());

        setBackground(new java.awt.Color(255, 255, 255));
        titlePanel.setLayout(new java.awt.GridBagLayout());

        titlePanel.setOpaque(false);
        sunLogoLbl.setBackground(new java.awt.Color(89, 79, 191));
        sunLogoLbl.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/j2ee/blueprints/ui/resources/logo_sun.gif")));
        sunLogoLbl.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        titlePanel.add(sunLogoLbl, gridBagConstraints);

        titleSubPnl.setLayout(new java.awt.GridBagLayout());

        titleLbl.setBackground(new java.awt.Color(251, 226, 73));
        titleLbl.setFont(new java.awt.Font("Dialog", 1, 24));
        titleLbl.setForeground(new java.awt.Color(89, 79, 191));
        titleLbl.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("NB_title"));
        titleLbl.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 12, 1, 1));
        titleLbl.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        titleSubPnl.add(titleLbl, gridBagConstraints);

        titleSubLbl.setBackground(new java.awt.Color(251, 226, 73));
        titleSubLbl.setForeground(new java.awt.Color(89, 79, 191));
        titleSubLbl.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("NB_subtitle"));
        titleSubLbl.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 12, 1, 1));
        titleSubLbl.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        titleSubPnl.add(titleSubLbl, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        titlePanel.add(titleSubPnl, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 7, 12);
        add(titlePanel, gridBagConstraints);

        toolbarPanel.setLayout(new java.awt.GridBagLayout());

        toolbarPanel.setOpaque(false);
        entryCbx.setMaximumRowCount(16);
        entryCbx.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                entryCbxItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        toolbarPanel.add(entryCbx, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 1, 7);
        add(toolbarPanel, gridBagConstraints);

        tabbedPnl.addTab(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("categoryPnl"), categoryPnl);

        tabbedPnl.addTab(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("solutionPnl"), solutionPnl);

        tabbedPnl.addTab(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("designPnl"), designPnl);

        tabbedPnl.addTab(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("examplePnl"), examplePnl);

        tabbedPnl.addTab(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("homePnl"), homePnl);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 12, 12);
        add(tabbedPnl, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void entryCbxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_entryCbxItemStateChanged
        if(!navigating) {
            if(lastSelectedIndex != entryCbx.getSelectedIndex()) {
                // sometimes Swing calls this twice - only select the new
                // entry if a new entry was selected.
                lastSelectedIndex = entryCbx.getSelectedIndex();
                selectNewEntry();
            }
        }
    }//GEN-LAST:event_entryCbxItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel categoryPnl;
    private javax.swing.JPanel designPnl;
    private javax.swing.JComboBox entryCbx;
    private javax.swing.JPanel examplePnl;
    private javax.swing.JPanel homePnl;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JPanel solutionPnl;
    private javax.swing.JLabel sunLogoLbl;
    private javax.swing.JTabbedPane tabbedPnl;
    private javax.swing.JLabel titleLbl;
    private javax.swing.JPanel titlePanel;
    private javax.swing.JLabel titleSubLbl;
    private javax.swing.JPanel titleSubPnl;
    private javax.swing.JPanel toolbarPanel;
    // End of variables declaration//GEN-END:variables

    private static final String UI_RESOURCES_URL = 
        "/org/netbeans/modules/j2ee/blueprints/ui/resources"; // NOI18N
    private static final String ICON_CATEGORY = 
        UI_RESOURCES_URL + "/category.gif"; // NOI18N
    private static final String ICON_ARTICLE = 
        UI_RESOURCES_URL + "/article.gif"; // NOI18N
    private static ResourceBundle bundle = ResourceBundle.getBundle(
        "org/netbeans/modules/j2ee/blueprints/ui/Bundle"); // NOI18N
    static final String CATALOG_RESOURCES_URL = 
        "/org/netbeans/modules/j2ee/blueprints/catalog/resources"; // NOI18N
    
    public static final String TAB_CATEGORY = "categoryPnl"; // NOI18N
    public static final String TAB_SOLUTION = "solutionPnl"; // NOI18N
    public static final String TAB_DESIGN   = "designPnl";   // NOI18N
    public static final String TAB_EXAMPLE  = "examplePnl";  // NOI18N
    public static final String TAB_HOME  = "homePnl";  // NOI18N
    public final HashMap TABS = new HashMap();
    
    private SolutionsCatalog solutionsCatalog = SolutionsCatalog.getInstance();
    private BrowseHistory history = new BrowseHistory();
    private BrowseHistoryToken historyToken = new BrowseHistoryToken();
    
    // True if a change in the combo box should not trigger events.
    private boolean navigating = false;
    private int lastSelectedIndex = -1;

    public Nbcategory getSelectedCategory() {
        Object entry = entryCbx.getSelectedItem();
        if(!(entry instanceof Nbcategory)) {
            // Scan up the list until we hit a category
            int index = entryCbx.getSelectedIndex();
            do {
                index--;
                entry = entryCbx.getItemAt(index);
            } while((index > 0) && !(entry instanceof Nbcategory));
        }
        return (Nbcategory)entry;
    }
    
    public Nbsolution getSelectedArticle() {
        Object entry = entryCbx.getSelectedItem();
        return (entry instanceof Nbsolution) ? (Nbsolution)entry : null;
    }
    
    public String getExampleId() {
        String result = null;
        Nbsolution solution = getSelectedArticle();
        if(solution != null) {
            result = solution.getExampleId(); 
        }
        return result;
    }
    
    private void initTabs() {
        TABS.put(TAB_CATEGORY, categoryPnl);
        TABS.put(TAB_SOLUTION, solutionPnl);
        TABS.put(TAB_DESIGN, designPnl);
        TABS.put(TAB_EXAMPLE, examplePnl);
        TABS.put(TAB_HOME, homePnl);
        tabbedPnl.removeAll();
    }
    
    private void initComboBox() {
        // Set up combo boxes:
        entryCbx.setRenderer(new EntryListCellRenderer());
        entryCbx.setModel(new EntryComboBoxModel());
        entryCbx.setSelectedIndex(0);
        history.clear();
        updateTabs();
        //updateButtons();
        historyToken = createBrowseHistoryToken();
    }
    
    private void selectNewEntry() {
        // Article and category will be set in the current history token
        // but scroll position and tab may be out of date.  Update them.
        historyToken.setScrollPosition(getScrollPosition());
        historyToken.setTab(getSelectedTabName());
        history.pushBackStack(historyToken);
                
        updateTabs();
        //updateButtons();
        
        // Create a new token that contains the new article and category.
        historyToken = createBrowseHistoryToken();
    }

    private void goForward() {
        if(!history.isForwardStackEmpty()) {
            navigateTo(history.forward(createBrowseHistoryToken()));
            //updateButtons();
        }
    }
    
    private void goBack() {
        if(!history.isBackStackEmpty()) {
            navigateTo(history.back(createBrowseHistoryToken()));
            //updateButtons();
        }
    }
    
    private BrowseHistoryToken createBrowseHistoryToken() {
        String category = getSelectedCategory().getId();
        Nbsolution solution = getSelectedArticle();
        String article = (solution == null) ? null : solution.getId();
        String tab = getSelectedTabName();
        int scrollPosition = getScrollPosition();
        return new BrowseHistoryToken(category, article, tab, scrollPosition);
    }
    
    private String getSelectedTabName() {
        Component selectedTab = tabbedPnl.getSelectedComponent();
        String result = null;
        Set entries = TABS.entrySet();
        Iterator iter = entries.iterator();
        while(iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if(entry.getValue() == selectedTab) {
                result = (String)entry.getKey();
            }
        }
        return result;
    }
    
    private int getScrollPosition() {
        int result = 0;
        Component selectedTab = tabbedPnl.getSelectedComponent();
        if(selectedTab != null) {
            result = ((BluePrintsTabPanel)selectedTab).getScrollPosition();
        }
        return result;
    }
    
    private void scrollTo(int position) {
        Component selectedTab = tabbedPnl.getSelectedComponent();
        if(selectedTab != null) {
            ((BluePrintsTabPanel)selectedTab).setScrollPosition(position);
        }
    }
    
    private void navigateTo(BrowseHistoryToken token) {
        if(token != null) {
            String category = token.getCategory();
            String article = token.getArticle();
            navigateTo(category, article);
            updateTabs();
            String tab = token.getTab();
            selectTab(tab);
            int scrollPosition = token.getScrollPosition();
            scrollTo(scrollPosition);
            historyToken = createBrowseHistoryToken();
        }
    }
    
    private void navigateTo(String category, String article) {
        navigating = true;  // prevent duplicate events
        if(category != null) {
            boolean foundCategory = false;
            int count = entryCbx.getItemCount();
            for(int i = 0; i < count; i++) {
                Object entry = entryCbx.getItemAt(i);
                if(entry instanceof Nbcategory) {
                    Nbcategory c = (Nbcategory)entry;
                    if(c.getId().equals(category)) {
                        foundCategory = true;
                        if(article == null) {
                            // Select just this category
                            entryCbx.setSelectedIndex(i);
                            break;
                        }
                    }
                    else {
                        if(foundCategory) {
                            // We found the category but not the article.
                            break;
                        }
                    }
                }
                else {
                    if(foundCategory) {
                        Nbsolution s = (Nbsolution)entryCbx.getItemAt(i);
                        if(s.getId().equals(article)) {
                            // Select this article
                            entryCbx.setSelectedIndex(i);
                            break;
                        }
                    }
                }
            }
        }
        navigating = false;
    }
    
    /*private void updateButtons() {
        backBtn.setEnabled(!history.isBackStackEmpty());
        forwardBtn.setEnabled(!history.isForwardStackEmpty());
    }*/
    
    private void showHome() {
        tabbedPnl.removeAll();
        tabbedPnl.addTab(bundle.getString(TAB_HOME),
                (Component)TABS.get(TAB_HOME));
    }
    
    private void updateTabs() {
        Nbcategory category = getSelectedCategory();
        Nbsolution solution = getSelectedArticle();

        // Ensure the category panel is visible when no solution is selected
        // and the other panels are visible when an solution is selected.
        if(solution == null) {
            if(category.getId().equals("HOME")) { // NOI18N
                showHome();
            } else {
                tabbedPnl.removeAll();
                tabbedPnl.addTab(bundle.getString(TAB_CATEGORY), 
                        (Component)TABS.get(TAB_CATEGORY)); 
            }
        }
        else {
            tabbedPnl.removeAll();
            tabbedPnl.addTab(bundle.getString(TAB_SOLUTION), 
                (Component)TABS.get(TAB_SOLUTION)); 
            tabbedPnl.addTab(bundle.getString(TAB_DESIGN), 
                (Component)TABS.get(TAB_DESIGN)); 
            tabbedPnl.addTab(bundle.getString(TAB_EXAMPLE), 
                (Component)TABS.get(TAB_EXAMPLE)); 
        }
        
        updateCategoryTab();
        updateSolutionTab();
        updateDesignTab();
        updateExampleTab();
        updateHomeTab();
    }
    
    private void selectTab(String tab) {
        tabbedPnl.setSelectedComponent((Component)TABS.get(tab));
    }
    
    private void updateCategoryTab() {
        ((BluePrintsTabPanel)categoryPnl).updateTab();
    }
    
    private void updateSolutionTab() {
        ((BluePrintsTabPanel)solutionPnl).updateTab();
    }
    
    private void updateHomeTab() {
        ((BluePrintsTabPanel)homePnl).updateTab();
    }
    
    private void updateDesignTab() {
        Nbcategory category = getSelectedCategory();
        Nbsolution solution = getSelectedArticle();
        if(solution != null) {
            Nbwriteup writeup = solution.getNbwriteup();
            if(writeup.getDesigndocPath() == null || (writeup.getDesigndocPath().trim().equals(""))) { //NOI18N
                tabbedPnl.remove(designPnl);
            }
        }
        ((BluePrintsTabPanel)designPnl).updateTab();
    }
    
    public void updateExampleTab() {
        Nbcategory category = getSelectedCategory();
        Nbsolution solution = getSelectedArticle();
        if(solution != null) {
            String exampleIds = solution.getExampleId();
            if(exampleIds.trim().equals("")) { //NOI18N
                tabbedPnl.remove(examplePnl);
            }
        }
        ((BluePrintsTabPanel)examplePnl).updateTab();
    }
    
    /**
     * Backing model for the entry drop-down.
     * Gets its data from nbcatalog.xml.
     */
    private class EntryComboBoxModel
        extends DefaultComboBoxModel
    {

        private ArrayList entries = new ArrayList();
        private boolean firstTime = true;
        
        public EntryComboBoxModel() {
            //add HOME page
            Nbcategory homeCategory = new Nbcategory();
            homeCategory.setId("HOME"); // NOI18N
            homeCategory.setDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("homeCatDesc"));
            homeCategory.setCategoryName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("homeCatName"));
            entries.add(homeCategory);
            
            //Populate Current Version Solutions
            Nbcatalog nbcatalog = solutionsCatalog.getCatalogXml();
            populateEntries(nbcatalog);
        }
        
        public int getSize() {
            return entries.size();
        }
        
        public Object getElementAt(int index) {
            return entries.get(index);
        }
        
        private void populateEntries(Nbcatalog nbcatalog){
            Nbcategory[] cats = nbcatalog.getNbcategory();
            for(int categoryNum = 0; categoryNum < cats.length; categoryNum++) {
                Nbcategory category = cats[categoryNum];
                if(category.getShowSpec().equals("true") && firstTime){
                    Nbcategory enclCat = new Nbcategory();
                    String specname = category.getSpec();
                    enclCat.setId(specname); 
                    enclCat.setDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/BundleBpcatalog").getString(getCatKeyName(specname)));
                    enclCat.setCategoryName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/BundleBpcatalog").getString(getCatKeyDesc(specname)));
                    entries.add(enclCat);
                    firstTime = false;
                }
                entries.add(category);
                
                Nbsolution[] solutions = category.getNbsolution();
                for(int solutionNum=0; solutionNum < solutions.length; solutionNum++){
                    entries.add(solutions[solutionNum]);
                }
            }
        }
        
    }
    
    /**
     * Cell renderer for the entry drop-down
     *
     * Adds an icon and changes the text of the cell to match the name of
     * the category or article.
     */
    private static class EntryListCellRenderer 
        extends DefaultListCellRenderer
    {
        private ImageIcon categoryIcon;
        private ImageIcon articleIcon;

        public EntryListCellRenderer() {
            this.categoryIcon = new ImageIcon(getClass().getResource(
                ICON_CATEGORY));
            this.articleIcon = new ImageIcon(getClass().getResource(
                ICON_ARTICLE));
        }

        public Component getListCellRendererComponent(JList list,
            Object value, int index, boolean isSelected, boolean cellHasFocus)
        {
            Component result = super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);
            JLabel label = (JLabel)result;
            ResourceBundle bundleBpcatalog = java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/BundleBpcatalog");
            String catName=null;
            String fullName=null;
            if(value instanceof Nbcategory) {
                Nbcategory category = (Nbcategory)value;
                label.setIcon(categoryIcon);
                
                try {
                    // construct key : "category/CATEGORY-ID/category-name"
                    catName = bundleBpcatalog.getString(getCatKeyName(category.getId()));
                } catch (Exception e) {
                    catName = category.getCategoryName().trim();
                }
                label.setText(catName);
            }
            else if(value instanceof Nbsolution) {
                Nbsolution solution = (Nbsolution)value;
                label.setIcon(articleIcon);
                // construct key : "solution/SOLUTION-ID/full-name"
                String solKey = "solution/" + solution.getId().trim() + "/full-name";
                try {
                    fullName = bundleBpcatalog.getString(solKey);
                } catch (Exception e) {
                    fullName = solution.getFullName().trim();
                }
                label.setText(fullName);
                // Tab the articles so they look like they're in the category
                label.setBorder(new EmptyBorder(0, 19, 0, 0));
            }
            return result;
        }
    }
    
    private static String getCatKeyName(String catName){
        String nameKey = "category/" + catName.trim() + "/category-name"; //NOI18N
        return nameKey;
    }
    
    private static String getCatKeyDesc(String catDesc){
        String descKey = "category/" + catDesc.trim() + "/description"; //NOI18N
        return descKey;
    }
    
}

