/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import org.netbeans.modules.j2ee.dd.api.web.JspPropertyGroup;
import org.netbeans.modules.j2ee.dd.api.web.*;
import org.netbeans.modules.j2ee.ddloaders.web.*;
import org.netbeans.modules.xml.multiview.ui.*;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.api.project.SourceGroup;

/**
 * @author  mkuchtiak
 */
public class OverviewPanel extends SectionInnerPanel implements java.awt.event.ItemListener {
    DDDataObject dObj;
    WebApp webApp;
    /** Creates new form JspPGPanel */
    public OverviewPanel(SectionView sectionView, DDDataObject dObj) {
        super(sectionView);
        this.dObj=dObj;
        webApp=dObj.getWebApp();
        initComponents();
        
        // Display Name
        dispNameTF.setText(webApp.getDefaultDisplayName());
        addModifier(dispNameTF);
        
        // Description
        Utils.makeTextAreaLikeTextField(descriptionTA,dispNameTF);
        descriptionTA.setText(webApp.getDefaultDescription());
        addModifier(descriptionTA);
        
        // Distributable
        jCheckBox1.setSelected(webApp.isDistributable());
        jCheckBox1.addItemListener(this);
        
        // Session Timeout
        stTF.setText(getSessionTimeout());
        addValidatee(stTF);
        
    }
    
    private String getSessionTimeout() {
        SessionConfig config = webApp.getSingleSessionConfig();
        if (config==null) return "";
        java.math.BigInteger timeout = config.getSessionTimeout();
        return (timeout==null?"":timeout.toString());
    }
    
    private void setSessionTimeout(String text) {
        String val = text.trim();
        SessionConfig config = webApp.getSingleSessionConfig();
        if (config!=null) {
            if (text.length()==0) webApp.setSessionConfig(null);
            else config.setSessionTimeout(new java.math.BigInteger(val));
        } else if (text.length()>0) {
            try {
                SessionConfig newConfig = (SessionConfig)webApp.createBean("SessionConfig");
                newConfig.setSessionTimeout(new java.math.BigInteger(val));
                webApp.setSessionConfig(newConfig);
            } catch (ClassNotFoundException ex){}
        }

    }
    
    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
        if (comp==stTF) {
            String text = value.trim();
            if (text.length()==0) {
                getSectionView().getErrorPanel().clearError();
            } else {
                java.math.BigInteger st=null;
                try {
                    st = new java.math.BigInteger(text);
                } catch (NumberFormatException ex) {}
                if (st==null) {
                    getSectionView().getErrorPanel().setError(new Error(Error.TYPE_FATAL, Error.ERROR_MESSAGE, "Invalid Value : "+text, stTF));
                    return;
                }
                getSectionView().getErrorPanel().clearError();
            }
        }
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
        String text = ((String)value).trim();
        if (source==dispNameTF) {
            webApp.setDisplayName(text.length()==0?null:text);
        } else if (source==descriptionTA) {
            webApp.setDescription(text.length()==0?null:text);
        } else if (source==stTF) {
            setSessionTimeout(text);
        }
    }
    
    public void rollbackValue(javax.swing.text.JTextComponent source) {
        if (source==stTF) {
            stTF.setText(getSessionTimeout());
        }
    }
    
    public void linkButtonPressed(Object obj, String id) {
    } 
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        filler = new javax.swing.JPanel();
        dispNameLabel = new javax.swing.JLabel();
        dispNameTF = new javax.swing.JTextField();
        descriptionLabel = new javax.swing.JLabel();
        descriptionTA = new javax.swing.JTextArea();
        jCheckBox1 = new javax.swing.JCheckBox();
        stLabel = new javax.swing.JLabel();
        stTF = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        filler.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(filler, gridBagConstraints);

        dispNameLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_displayName_mnem").charAt(0));
        dispNameLabel.setLabelFor(dispNameTF);
        dispNameLabel.setText(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_displayName"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 10);
        add(dispNameLabel, gridBagConstraints);

        dispNameTF.setColumns(30);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(dispNameTF, gridBagConstraints);

        descriptionLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_description_mnem").charAt(0));
        descriptionLabel.setLabelFor(descriptionTA);
        descriptionLabel.setText(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_description"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 10);
        add(descriptionLabel, gridBagConstraints);

        descriptionTA.setRows(3);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 10);
        add(descriptionTA, gridBagConstraints);

        jCheckBox1.setMnemonic(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_distributable_mnem").charAt(0));
        jCheckBox1.setText(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_distributable"));
        jCheckBox1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(jCheckBox1, gridBagConstraints);

        stLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_sessionTimeout_mnem").charAt(0));
        stLabel.setLabelFor(stTF);
        stLabel.setText(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_sessionTimeout"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 10);
        add(stLabel, gridBagConstraints);

        stTF.setColumns(5);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        add(stTF, gridBagConstraints);

        jLabel1.setText(org.openide.util.NbBundle.getMessage(OverviewPanel.class, "LBL_min"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 0);
        add(jLabel1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel descriptionLabel;
    private javax.swing.JTextArea descriptionTA;
    private javax.swing.JLabel dispNameLabel;
    private javax.swing.JTextField dispNameTF;
    private javax.swing.JPanel filler;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel stLabel;
    private javax.swing.JTextField stTF;
    // End of variables declaration//GEN-END:variables
 
    public void itemStateChanged(java.awt.event.ItemEvent evt) {                                            
        // TODO add your handling code here:
        if (evt.getSource() == jCheckBox1) {
            dObj.modelUpdatedFromUI();
            dObj.setChangedFromUI(true);
            webApp.setDistributable(jCheckBox1.isSelected());
            dObj.setChangedFromUI(false);
        }
    }
    
    /** This will be called before model is changed from this panel
     */
    protected void startUIChange() {
        dObj.setChangedFromUI(true);
    }
    
    /** This will be called after model is changed from this panel
     */
    protected void endUIChange() {
        dObj.modelUpdatedFromUI();
        dObj.setChangedFromUI(false);
    }
}
