/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectGenerator;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.EarProjectType;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/**
 * Wizard to create a new enterprise application project which "contains" a 
 * web application and/or an ejb module and/or an application client.
 *
 * @author vkraemer
 */
public final class CompleteEarProjectWizardIterator extends NewEarProjectWizardIterator {
    
    public Set instantiate() throws IOException {
        File dirF = (File) wiz.getProperty(WizardProperties.PROJECT_DIR);
        String name = (String) wiz.getProperty(WizardProperties.NAME);
        String serverInstanceID = (String) wiz.getProperty(WizardProperties.SERVER_INSTANCE_ID);
        String j2eeLevel = (String) wiz.getProperty(WizardProperties.J2EE_LEVEL);
        String sourceLevel = (String)wiz.getProperty(WizardProperties.SOURCE_LEVEL);
        return testableInstantiate(dirF,name,j2eeLevel, serverInstanceID, sourceLevel);
    }
    
    Set<FileObject>testableInstantiate(File dirF, String name, String j2eeLevel,
            String serverInstanceID, String sourceLevel) throws IOException {
        Set<FileObject> resultSet = new HashSet<FileObject>();
        AntProjectHelper h = EarProjectGenerator.createProject(dirF, name, j2eeLevel, serverInstanceID, sourceLevel);
        String tmp = constructWarName(name);// .toLowerCase()+"-war"; //NOI18N
        File webAppDir = new File(dirF, tmp);
        tmp = constructEjbJarName(name);
        File ejbJarDir = new File(dirF,tmp);
        tmp = constructCarName(name);
        File carDir = new File(dirF,tmp);
        try {
            FileObject webRoot = h.getProjectDirectory().getFileObject("web");//NOI18N
            FileObject indexJSPFo = getIndexJSPFO(webRoot, "index"); //NOI18N
            assert indexJSPFo != null : "webRoot: " + webRoot + ", defaultJSP: index";//NOI18N
            resultSet.add (indexJSPFo);
        } catch (Exception x) {
            //PENDING
        }
        
        FileObject dir = FileUtil.toFileObject(FileUtil.normalizeFile(dirF));
        Project p = ProjectManager.getDefault().findProject(dir);
        
        resultSet.add(dir);
        
        try {
            AuxiliaryConfiguration aux = h.createAuxiliaryConfiguration();
            ReferenceHelper refHelper = new ReferenceHelper(h, aux, h.getStandardPropertyEvaluator ());
            EarProjectProperties epp = new EarProjectProperties(
                    (EarProject) p.getLookup().lookup(EarProject.class),
                    refHelper, new EarProjectType());
            
            //ejbJarDir.mkdirs();
            // XXX waiting for Chris to expose an API 
            h = EjbJarProjectGenerator.createProject(FileUtil.normalizeFile(ejbJarDir),constructEjbJarProjectName(name),
                EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.WAR), serverInstanceID);
            FileObject dir2 = FileUtil.toFileObject(FileUtil.normalizeFile(ejbJarDir));
            resultSet.add(dir2);
            p = ProjectManager.getDefault().findProject(dir2);
            epp.addJ2eeSubprojects(new Project[] { p });
            
            WebProjectCreateData createData = new WebProjectCreateData();
            createData.setProjectDir(FileUtil.normalizeFile(webAppDir));
            createData.setName(constructWebProjectName(name));
            createData.setServerInstanceID(serverInstanceID);
            createData.setSourceStructure(WebProjectUtilities.SRC_STRUCT_BLUEPRINTS);
            createData.setJavaEEVersion(EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.WAR));
            createData.setContextPath("/"+constructWebProjectName(name)); //NOI18N
            h = WebProjectUtilities.createProject(createData);
            
            dir2 = FileUtil.toFileObject(FileUtil.normalizeFile(webAppDir));
            p = ProjectManager.getDefault().findProject(dir2);
            epp.addJ2eeSubprojects(new Project[] { p });
            resultSet.add(dir2);
            //create appclient subproject
            h = AppClientProjectGenerator.createProject(FileUtil.normalizeFile(carDir),constructCarProjectName(name),
                null, EarProjectGenerator.checkJ2eeVersion(j2eeLevel, serverInstanceID, J2eeModule.WAR), serverInstanceID);
            dir2 = FileUtil.toFileObject(FileUtil.normalizeFile(carDir));
            p = ProjectManager.getDefault().findProject(dir2);
            epp.addJ2eeSubprojects(new Project[] { p });            
            resultSet.add(dir2);
        } catch (SecurityException se) {
            // log the issue for now 
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, 
                se.getLocalizedMessage());
        }
        
        // Returning set of FileObject of project diretory. 
        // Project will be open and set as main
        return resultSet;
    }
    
    private static String constructWarName(final String name) {
        return name.toLowerCase(Locale.US)+"-war"; // NOI18N
    }

    private static String constructEjbJarName(final String name) {
        return name.toLowerCase(Locale.US)+"-ejb"; // NOI18N
    }

    private static String constructWebProjectName(final String name) {
        return name.toLowerCase(Locale.US)+"-war"; // name+"Web"; // NOI18N
    }

    private static String constructEjbJarProjectName(final String name) {
        return name.toLowerCase(Locale.US)+"-ejb"; //name+"EjbJar"; // NOI18N
    }
    
    private static String constructCarName(final String name) {
        return name.toLowerCase(Locale.US)+"-car"; // NOI18N
}

    private static String constructCarProjectName(final String name) {
        return name.toLowerCase(Locale.US)+"-car"; // name+"Car"; // NOI18N
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i=0; i< displayName.length(); i++) {
            char c = displayName.charAt(i);
            if ((!firstLetter && Character.isJavaIdentifierPart(c)) || (firstLetter && Character.isJavaIdentifierStart(c))) {
                firstLetter = false;
                if (Character.isUpperCase(c)) {
                    c = Character.toLowerCase(c);
                }
                builder.append(c);
            }
        }
        return builder.length() == 0 ? NbBundle.getMessage(CompleteEarProjectWizardIterator.class,"TXT_DefaultPackageName") : builder.toString();
    }
    
}
