/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.earproject.ui;

import java.io.File;
import org.netbeans.api.project.Project;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.EarProjectType;
import org.netbeans.modules.j2ee.earproject.test.TestUtil;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

/**
 * @author vkraemer
 */
public class EarCustomizerProviderTest extends NbTestCase {
    
    public EarCustomizerProviderTest(String testName) {
        super(testName);
    }
    
    public void testCreateDialog() throws Exception {
        TestUtil.makeScratchDir(this);
        String serverID = TestUtil.registerSunAppServer(this);
        File prjDirF = new File(getWorkDir(), "testEA");
        AntProjectHelper antProjHelper =
                EarProjectGenerator.createProject(prjDirF, "EarCustomizerTest",
                J2eeModule.JAVA_EE_5, serverID, "1.5");
        AntBasedProjectType abpt = new EarProjectType();
        Project proj = abpt.createProject(antProjHelper);
        AuxiliaryConfiguration aux = antProjHelper.createAuxiliaryConfiguration();
        ReferenceHelper refHelper = new ReferenceHelper(antProjHelper, aux, antProjHelper.getStandardPropertyEvaluator());
        EarCustomizerProvider ecp = new EarCustomizerProvider(proj,antProjHelper,refHelper,abpt);
        ecp.createDialog();
    }
    
}
