/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import org.openide.filesystems.FileObject;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method;

import java.io.IOException;

/**
 * @author pfiala
 */
public abstract class EntityAndSessionGenerator {
    protected EjbGenerationUtil genUtil = new EjbGenerationUtil();

    public String generateLocal(String pkg, FileObject foPkg, String className, String ejbName) throws IOException {
        return genUtil.generateInterface(pkg, foPkg, className, ejbName, "local", null);
    }

    public String generateLocalHome(String pkg, FileObject foPkg, String className, String local, String ejbName)
            throws IOException {
        return genUtil.generateInterface(pkg, foPkg, className, ejbName, "local-home", getPrimaryMethods(local, null));
    }

    public String generateRemote(String pkg, FileObject foPkg, String className, String ejbName) throws IOException {
        return genUtil.generateInterface(pkg, foPkg, className, ejbName, "remote", null);
    }

    public String generateHome(String pkg, FileObject foPkg, String className, String remote, String ejbName)
            throws IOException {
        return genUtil.generateInterface(pkg, foPkg, className, ejbName, "home", getPrimaryMethods(null, remote));
    }

    protected abstract Method[] getPrimaryMethods(String local, String remote);

    public void generateBusinessInterfaces(String packageName, FileObject packageFile, String businessIntfName,
            String ejbName, String ejbClass, String componentName) throws IOException {
        genUtil.generateBusinessInterfaces(packageName, packageFile, businessIntfName, ejbName, ejbClass, componentName);
    }
}
