/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard;

import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;
import org.openide.filesystems.FileObject;
import org.netbeans.modules.j2ee.common.TransactionSupport;
import org.netbeans.modules.j2ee.common.Transaction;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.netbeans.api.project.Project;

import javax.swing.*;
import java.io.IOException;

/**
 * @author pfiala
 */
public class TransactionHelper {
    private Transaction transaction;

    public void initialize(final WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject(wizardDescriptor);
        EjbJar ejbModule = EjbJar.getEjbJars(project)[0];
        try {
            final FileObject ejbJarFile = ejbModule.getDeploymentDescriptor();
            if (ejbJarFile == null) {
                return;
            }
            final DataObject dataObject = DataObject.find(ejbJarFile);
            final TransactionSupport transactionSupport = (TransactionSupport) dataObject.getCookie(TransactionSupport.class);
            if (transactionSupport != null) {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        Transaction transaction = transactionSupport.openTransaction();
                        if (transaction == null) {
//TODO zavreni wizardu se presune do wizardu, initialize bude vracet boolean...                            
                            ((JButton) wizardDescriptor.getClosingOptions()[1]).doClick();
                        } else {
                            TransactionHelper.this.transaction = transaction;
                        }
                    }
                });
            }
        } catch (IOException e) {
            e.printStackTrace();  
        }
    }

    public void write() throws IOException {
        if (transaction != null) {
            transaction.commit();
            transaction = null;
        }
    }

    public void uninitialize() {
        if (transaction != null) {
            transaction.rollback();
            transaction = null;
        }
    }
}
