/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.entity;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.common.FQNSearch;

/**
 *
 * @author  ChrisWebster
 * @author Martin Adamek
 */
public class EntityEJBWizardPanel extends javax.swing.JPanel {
    
    public static final String[] PK_TYPES = {
        "Boolean", "Character", "Double", "Float", "Integer", "Long", "Short", "String", //NOI18N
        "Object", "java.math.BigDecimal" // NOI18N
    };

    private ChangeListener listener;

    /** Creates new form EntityEJBWizardPanel */
    public EntityEJBWizardPanel(ChangeListener changeListener) {
        this.listener = changeListener;
        initComponents();

        localCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                listener.stateChanged(null);
            }
        });

        remoteCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                listener.stateChanged(null);
            }
        });

        primaryKeyTextField.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                listener.stateChanged(null);
            }
            public void insertUpdate(DocumentEvent e) {
                listener.stateChanged(null);
            }
            public void removeUpdate(DocumentEvent e) {
                listener.stateChanged(null);
            }
        });
        
    }
    
    public boolean isCMP() {
        return cmpButton.isSelected();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        persistenceGroup = new javax.swing.ButtonGroup();
        persistenceTypeLabel = new javax.swing.JLabel();
        cmpButton = new javax.swing.JRadioButton();
        bmpButton = new javax.swing.JRadioButton();
        createInterfaceLabel = new javax.swing.JLabel();
        remoteCheckBox = new javax.swing.JCheckBox();
        localCheckBox = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        primaryKeyTextField = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(persistenceTypeLabel, org.openide.util.NbBundle.getMessage(EntityEJBWizardPanel.class, "LBL_PersistenceType"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(persistenceTypeLabel, gridBagConstraints);

        persistenceGroup.add(cmpButton);
        cmpButton.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("MN_Container").charAt(0));
        cmpButton.setSelected(true);
        cmpButton.setText(org.openide.util.NbBundle.getMessage(EntityEJBWizardPanel.class, "LBL_Container"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 0, 0);
        add(cmpButton, gridBagConstraints);
        cmpButton.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Container"));
        cmpButton.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Container"));

        persistenceGroup.add(bmpButton);
        bmpButton.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("MN_Bean").charAt(0));
        bmpButton.setText(org.openide.util.NbBundle.getMessage(EntityEJBWizardPanel.class, "LBL_Bean"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 0, 0);
        add(bmpButton, gridBagConstraints);
        bmpButton.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Bean"));
        bmpButton.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Bean"));

        org.openide.awt.Mnemonics.setLocalizedText(createInterfaceLabel, org.openide.util.NbBundle.getMessage(EntityEJBWizardPanel.class, "LBL_Interface"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 0, 0, 0);
        add(createInterfaceLabel, gridBagConstraints);

        remoteCheckBox.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("MN_Remote").charAt(0));
        remoteCheckBox.setText(org.openide.util.NbBundle.getMessage(EntityEJBWizardPanel.class, "LBL_Remote"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 0, 0);
        add(remoteCheckBox, gridBagConstraints);
        remoteCheckBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Remote"));
        remoteCheckBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Remote"));

        localCheckBox.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("MN_Local").charAt(0));
        localCheckBox.setSelected(true);
        localCheckBox.setText(org.openide.util.NbBundle.getMessage(EntityEJBWizardPanel.class, "LBL_Local"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 0, 0);
        add(localCheckBox, gridBagConstraints);
        localCheckBox.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Local"));
        localCheckBox.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("LBL_Local"));

        jLabel1.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("MN_PrimaryKey").charAt(0));
        jLabel1.setLabelFor(primaryKeyTextField);
        jLabel1.setText(org.openide.util.NbBundle.getBundle(EntityEJBWizardPanel.class).getString("LBL_PrimaryKeyClass"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 8);
        add(jLabel1, gridBagConstraints);

        primaryKeyTextField.setText("Long");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 8);
        add(primaryKeyTextField, gridBagConstraints);
        primaryKeyTextField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("ACS_PrimaryKeyField"));
        primaryKeyTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("ACS_PrimaryKeyField"));

        jButton1.setMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("MN_Browse").charAt(0));
        jButton1.setText("...");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 8, 0);
        add(jButton1, gridBagConstraints);
        jButton1.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("ACS_BrowsePK"));
        jButton1.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/entity/Bundle").getString("ACS_BrowsePK"));

    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        SwingUtilities.invokeLater (new Runnable() {
            public void run() {
                FQNSearch.showFastOpen(primaryKeyTextField);
            }
        });
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton bmpButton;
    private javax.swing.JRadioButton cmpButton;
    private javax.swing.JLabel createInterfaceLabel;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox localCheckBox;
    private javax.swing.ButtonGroup persistenceGroup;
    private javax.swing.JLabel persistenceTypeLabel;
    private javax.swing.JTextField primaryKeyTextField;
    private javax.swing.JCheckBox remoteCheckBox;
    // End of variables declaration//GEN-END:variables

    public boolean isRemote() {
        return remoteCheckBox.isSelected();
    }

    public boolean isLocal() {
        return localCheckBox.isSelected();
    }
    
    public String getPrimaryKeyClassName() {
        return primaryKeyTextField.getText();
    }
    
}
