/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.hints;

import java.util.*;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

/**
 *
 * @author Pavel Buzek
 */
public class EjbHintsProvider extends HintsProvider {
    
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.ejbcore"); // NOI18N
    
    /** Creates a new instance of EjbHintsProvider */
    public EjbHintsProvider() {
    }

    public List getHints(Document doc, int offset) {
        if (doc instanceof BaseDocument) {
	    BaseDocument baseDoc = (BaseDocument) doc;
	    org.netbeans.modules.j2ee.common.JMIUtils.beginJmiTransaction();
	    JMIUtils utils = null;
	    Resource resource = null;
	    try {
		utils = JMIUtils.get(baseDoc);
		resource = utils.getResource();
		FileObject fo = JavaModel.getFileObject(resource);
		if (fo == null || EjbJar.getEjbJar(fo) == null) {
		    return Collections.EMPTY_LIST;
		}
	    } finally {
		org.netbeans.modules.j2ee.common.JMIUtils.endJmiTransaction();
	    }
            try {
                int realStart = Utilities.getFirstNonWhiteFwd(baseDoc, Utilities.getRowStart(baseDoc, offset));
                int realEnd = Utilities.getFirstNonWhiteBwd(baseDoc, Utilities.getRowEnd(baseDoc, offset));
                if (realStart > realEnd) {
                    return Collections.EMPTY_LIST;
                }
                offset = Math.min(Math.max(offset, realStart), realEnd);
                
                List result = new ArrayList();
                Set/*<String>*/ handledDescriptions = new HashSet/*<String>*/();
                
                JavaModel.getJavaRepository().beginTrans(false);
                
                try {
                    if (resource == null)
                        return result;
                    JavaModel.setClassPath(resource);
                    if (ERR.isLoggable(ErrorManager.INFORMATIONAL)) {
                        Element el = resource.getElementByOffset(offset);
                        
                        ERR.log("el=" + el); // NOI18N
                    }                    
                    Element e = resource.getElementByOffset(offset);
                    while (e != null && !(e instanceof Feature || e instanceof StatementBlock || e instanceof Resource)) {
                        e = (Element) e.refImmediateComposite();
                    }
                    if (e instanceof CallableFeature) {
                        CallableFeature feature = (CallableFeature) e;

                        if (feature != null) {
                            PositionBounds bounds = JavaMetamodel.getManager().getElementPosition(feature);
                            if (feature instanceof Method &&
                                bounds.getBegin().getOffset() <= offset && 
                                bounds.getEnd().getOffset() >= offset) {
                                for (int i = 0; i < methodHintCreators.length; i++) {
                                    methodHintCreators[i].createHint(utils, resource, doc, (Method) feature, offset, result);
                                }
                            }
                         }
                    }                    
                } finally {
                    JavaModel.getJavaRepository().endTrans();
                }
                return result;
            } catch (BadLocationException e) {
		// see issue 64283
                //in case that the document is about to be closed 
                //the BLE can be throws from some editor utility classes
                //so we can swallow it in this case
            }
        }
        
        return Collections.EMPTY_LIST;
    }
    
    private static abstract class MethodHintCreator {
        public abstract void createHint(JMIUtils utils, Resource resource, Document doc, Method method, int offset, List result);
    }
    
    private static class ExposeInLocalHintCreator extends MethodHintCreator {
        public void createHint(JMIUtils utils, Resource resource, Document doc, Method method, int offset, List result) {
            if (Utils.canExposeInLocal(method)) {
                result.add(new ExposeMethodHint(method, ExposeMethodHint.LOCAL));
            }
        }
    }
    
    private static class ExposeInRemoteHintCreator extends MethodHintCreator {
        public void createHint(JMIUtils utils, Resource resource, Document doc, Method method, int offset, List result) {
            if (Utils.canExposeInRemote(method)) {
                result.add(new ExposeMethodHint(method, ExposeMethodHint.REMOTE));
            }
        }
    }
    private static MethodHintCreator[] methodHintCreators = new MethodHintCreator[] {
        new ExposeInLocalHintCreator(),
        new ExposeInRemoteHintCreator(),
    };
}
