/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 * Provide an action to select message destinations
 * @author  Chris Webster
 */
public class MessageDestinationPanel extends javax.swing.JPanel {

    public static final String IS_VALID = "MessageDestinationPanel_isValid"; //NOI18N

    private MessageDestinationPanelController controller;
    private DefaultComboBoxModel destinationModel;
    private ServiceLocatorStrategyPanel slPanel;
    
    /** Creates new form MessageDestinationPanel */
    public MessageDestinationPanel(final JButton okButton, String lastLocator) {
        initComponents();
        controller = new MessageDestinationPanelController();
        DefaultComboBoxModel model = new DefaultComboBoxModel(controller.getJMSProjectRepresentation());
        project.setModel(model);
        destinationModel = new DefaultComboBoxModel();
        okButton.setEnabled(false);
        destination.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                okButton.setEnabled(destination.getSelectedIndex() > -1);
            }
        });
        if (model.getSize() > 0) {
            project.setSelectedIndex(0);
        }
        slPanel = new ServiceLocatorStrategyPanel(lastLocator);
        slPanel.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(ServiceLocatorStrategyPanel.IS_VALID)) {
                    Object newvalue = evt.getNewValue();
                    if ((newvalue != null) && (newvalue instanceof Boolean)) {
                        boolean isServiceLocatorOk = ((Boolean)newvalue).booleanValue();
                        if (isServiceLocatorOk) {
                            checkDestination();
                        } else {
                            firePropertyChange(IS_VALID, true, false);
                        }
                    }
                }
            }
        });
        serviceLocatorPanel.add(slPanel, BorderLayout.CENTER);
    }
    
    public JMSDestination getSelectedDestination() {
        return (JMSDestination) destination.getSelectedItem();
    }
    
    public String getServiceLocator() {
        return slPanel.classSelected();
    } 
    
    private void populateDestinationCombo(Object selectedItem) {
        destinationModel = new DefaultComboBoxModel();
        try {
            populateEjbDestinationCombo(selectedItem);
        } catch (IOException ioe) {
             NotifyDescriptor nd = new NotifyDescriptor.Message(ioe.getMessage(),
                                   NotifyDescriptor.ERROR_MESSAGE);
             DialogDisplayer.getDefault().notify(nd);
        }
        destination.setModel(destinationModel);
        if (destinationModel.getSize()>0) {
            destination.setSelectedIndex(0);
        }
    }
     
    private void populateEjbDestinationCombo(Object selectedItem) throws IOException {
        EjbJar dd = controller.getEjbJar(selectedItem);
        if (dd != null) {
            List l = controller.extractEjbProjectDestinations(dd, selectedItem);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                destinationModel.addElement(it.next());
            }
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel jLabel3;

        project = new javax.swing.JComboBox();
        destination = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        serviceLocatorPanel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        project.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                projectActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        add(project, gridBagConstraints);
        project.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(MessageDestinationPanel.class, "ACSD_Project_Combo"));

        destination.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                destinationActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 5);
        add(destination, gridBagConstraints);
        destination.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(MessageDestinationPanel.class, "ACSD_Destination_Combo"));

        jLabel1.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ProjectMneumonic").charAt(0));
        jLabel1.setLabelFor(project);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Project"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jLabel1, gridBagConstraints);

        jLabel2.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_DestinationMneumonic").charAt(0));
        jLabel2.setLabelFor(destination);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Destination"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        add(jLabel2, gridBagConstraints);

        serviceLocatorPanel.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        add(serviceLocatorPanel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ProjectMustBeInSameApplication"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        add(jLabel3, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents

    private void destinationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_destinationActionPerformed
        checkDestination();
    }//GEN-LAST:event_destinationActionPerformed

    private void projectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_projectActionPerformed
        Object p = project.getSelectedItem();
        populateDestinationCombo(p);
    }//GEN-LAST:event_projectActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox destination;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JComboBox project;
    private javax.swing.JPanel serviceLocatorPanel;
    // End of variables declaration//GEN-END:variables

    protected void checkDestination() {
        if (destination.getSelectedItem() == null) {
            firePropertyChange(IS_VALID, true, false);
        } else {
            firePropertyChange(IS_VALID, false, true);
        }
    }
    
}
