/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.openide.filesystems.FileObject;


/**
 * Provide controller functionality for MessageDestinationPanel
 * @author ChrisWebster
 */
public class MessageDestinationPanelController {
    
    public Object[] getJMSProjectRepresentation() {
        Project[] proj = OpenProjects.getDefault().getOpenProjects();
        // TODO add support for destinations from web projects
        List l = new LinkedList();
        for (int i=0; i<proj.length; i++) {
            if (org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJars(proj[i]).length > 0) {
                l.add(new ProjectView(proj[i]));
            }
        }
        return (ProjectView[]) l.toArray(new ProjectView[l.size()]);
    }
    
    public EjbJar getEjbJar(Object item) throws IOException {
        Project p = ((ProjectView) item).getProject();
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar apiEjbJar = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJars(p)[0];
        return org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(apiEjbJar.getMetadataUnit());
    }
    
    public List extractEjbProjectDestinations(EjbJar dd, Object selectedItem) {
        Project p = ((ProjectView) selectedItem).getProject();
        List l = new LinkedList();
        
        AssemblyDescriptor ad = dd.getSingleAssemblyDescriptor();
        if (ad != null) {
            try {
                MessageDestination[] destination = ad.getMessageDestination();
                if (destination != null) {
                    for (int i = 0; i < destination.length; i++) {
                        String name = destination[i].getMessageDestinationName();
                        String type = findEjbBinding(name, dd);
                        if (type != null) {
                            l.add(new JMSDestination(name, p, type));
                        }
                    }
                }
            } catch (VersionNotSupportedException vnse) {
                
            }
        }
        
        return l;
    }
    
    private String findEjbBinding(String destinationName, EjbJar dd) {
        if (dd.getEnterpriseBeans() == null ||
                dd.getEnterpriseBeans().getEjbs() == null) {
            return null;
        }
        // see if a MDB exists with a destination link and matching type
        MessageDriven[] md = dd.getEnterpriseBeans().getMessageDriven();
        if (md != null) {
            for (int i=0; i < md.length; i++) {
                try {
                    if (md[i].getMessagingType() == null ||
                            md[i].getMessagingType().equals("javax.jms.MessageListener")) {
                        if (destinationName.equals(md[i].getMessageDestinationLink())) {
                            return md[i].getMessageDestinationType();
                        }
                    }
                } catch (VersionNotSupportedException vnse) {
                    
                }
            }
        }
        
        // look at all destination-refs to see if any consume jms messages
        Ejb[] ejb = dd.getEnterpriseBeans().getEjbs();
        for (int i=0; i < ejb.length; i++) {
            try {
                MessageDestinationRef[] refs = ejb[i].getMessageDestinationRef();
                String type = findDestinationRef(destinationName,refs);
                if (type != null) {
                    return type;
                }
            } catch (VersionNotSupportedException vnse) {
                
            }
        }
        
        return null;
    }
    
    private String findDestinationRef(String destination, MessageDestinationRef[] refs) {
        String type = null;
        if (refs != null) {
            for (int i=0; i<refs.length; i++) {
                boolean consumes =
                        org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef.MESSAGE_DESTINATION_USAGE_CONSUMES.equals(refs[i].getMessageDestinationUsage());
                String destinationType = refs[i].getMessageDestinationType();
                boolean jms =
                        "javax.jms.Queue".equals(destinationType) || //NOI18N
                        "javax.jms.Topic".equals(destinationType);   //NOI18N
                if (consumes && jms) {
                    if (destination.equals(refs[i].getMessageDestinationLink())) {
                        type = destinationType;
                    }
                }
            }
        }
        return type;
    }
    
    private static class ProjectView {
        private Project p;
        public ProjectView(Project p) {
            this.p = p;
        }
        
        public String toString() {
            return ProjectUtils.getInformation(p).getDisplayName();
        }
        
        public Project getProject() {
            return p;
        }
        
    }
    
}