/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.JavaProjectConstants;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbProjectConstants;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.ui.PersistenceNode;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.j2ee.ejbjarproject.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.libraries.LibrariesNode;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WebServicesClientView;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesView;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;




public final class LogicalViewChildren extends Children.Keys implements ChangeListener {

    private static final boolean DISPLAY_EJB_NODE =
        Boolean.getBoolean("org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.DISPLAY_EJB_NODE"); // NOI18N

    private static final boolean DISPLAY_ORM_NODE =
        Boolean.getBoolean("org.netbeans.modules.j2ee.ejbjarproject.ui.logicalview.DISPLAY_ORM_NODE"); // NOI18N

    public static final String KEY_TEST_DIR = "testDir"; // NOI18N
    public static final String KEY_DOC_BASE = "docBase"; //NOI18N
    public static final String KEY_EJBS = "ejbKey"; //NOI18N
    public static final String KEY_ORM = "persistenceKey"; //NOI18N
    public static final String KEY_SERVICE_REFS = "serviceRefs"; // NOI18N
    public static final String WEBSERVICES_DIR = "webservicesDir"; // NOI18N
    public static final String KEY_SETUP_DIR = "setupDir"; //NOI18N
    public static final String KEY_LIBRARIES = "libraries"; //NOI18N
    public static final String KEY_TEST_LIBRARIES = "testLibraries"; //NOI18N
    
    private static final String JAX_WS_PATH="nbproject/jax-ws.xml"; //NOI18N
    
    private Sources sources;
    private EjbJar jp;
    private ClassPath cp;
    private Project project;
    private PropertyEvaluator evaluator;
    private UpdateHelper updateHelper;
    private ReferenceHelper refHelper;
    private AntProjectHelper helper;
    
    private JaxWsChangeListener jaxWsListener;
    private MetaInfListener metaInfListener;	
    private WsdlCreationListener wsdlListener;
    private JaxRPCChangeListener jaxrpcChangeListener;
    private FileObject wsdlFolder;

//    private WsdlCreationListener wsdlListener;

    public LogicalViewChildren(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper ) {
        assert project != null;
        this.project = project;
        // AB,MA: hack: this class is used for the logical view of the ejb freeform project
        // updateHelper, evaluator and refHelper will be null when called from the freeform project
        this.evaluator = evaluator;
        this.updateHelper = updateHelper;
        if (updateHelper != null) {
            this.helper = updateHelper.getAntProjectHelper();
        }
        this.refHelper = refHelper;
        EjbJar jps[] = EjbJar.getEjbJars(project);
        assert jps.length > 0;
        jp = jps[0];

        sources = ProjectUtils.getSources(project);
        assert sources != null;
        cp = org.netbeans.spi.java.classpath.support.ClassPathSupport.createClassPath(getRoots());
        
        metaInfListener = new MetaInfListener();
        wsdlListener = new WsdlCreationListener();
        jaxrpcChangeListener = new JaxRPCChangeListener();
        jaxWsListener = new JaxWsChangeListener();
    }

    private FileObject[] getRoots() {
        SourceGroup[] groups = sources.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
        FileObject[] roots = new FileObject[groups.length];
        for (int i = 0; i < groups.length; i++) {
            roots[i] = groups[i].getRootFolder();
        }
        return roots;
    }

    protected void addNotify() {
        super.addNotify();
        sources.addChangeListener( this );
        
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel!=null) jaxWsModel.addPropertyChangeListener(jaxWsListener);
        
        EjbJar ejbModule = EjbJar.getEjbJar(helper.getProjectDirectory());
        if (ejbModule != null) {
            FileObject metaInf = ejbModule.getMetaInf();
            if (metaInf!=null) {
                metaInf.addFileChangeListener(metaInfListener);
                metaInf.addFileChangeListener(jaxrpcChangeListener);
            }
        }
        WebServicesClientSupport wsClientSupportImpl = 
                WebServicesClientSupport.getWebServicesClientSupport(helper.getProjectDirectory());
        FileObject wsdlDir = null;
        try {
            wsdlDir = wsClientSupportImpl.getWsdlFolder(false);
            if (wsdlDir!=null) wsdlFolder = wsdlDir;
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        if (wsdlFolder != null) {
            wsdlFolder.addFileChangeListener(wsdlListener);
        }
        
        createNodes();
    }

    private void createNodes() {
        List l = new ArrayList();
        l.add(KEY_EJBS);
        l.add(KEY_ORM);
  
        // show WS and WSClient nodes only if there are any web services in the project
        JAXWSSupport jwss = JAXWSSupport.getJAXWSSupport(project.getProjectDirectory());
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if ((jwss != null) && 
            (jaxWsModel != null) && 
            (jaxWsModel.getServices() != null) && 
            (jaxWsModel.getServices().length > 0)) {
                l.add(WEBSERVICES_DIR);
        } else {
            WebServicesSupport wss = WebServicesSupport.getWebServicesSupport(project.getProjectDirectory());
            if (wss!=null) {
                List wServices = wss.getServices();
                if ((wServices != null)  && (!wServices.isEmpty())) {
                    l.add(WEBSERVICES_DIR);
                }
            }
        }
        JAXWSClientSupport jwcss = JAXWSClientSupport.getJaxWsClientSupport(project.getProjectDirectory());
        if ((jwcss != null) &&
            (jaxWsModel != null) && 
            (jaxWsModel.getClients() != null) && 
            (jaxWsModel.getClients().length > 0)) {
                l.add(KEY_SERVICE_REFS);
        } else {
            WebServicesClientSupport wscs = WebServicesClientSupport.getWebServicesClientSupport(project.getProjectDirectory());
            if (wscs!=null) {
                List wsClients = wscs.getServiceClients();
                if ((wsClients != null)  && (!wsClients.isEmpty())) {
                    l.add(KEY_SERVICE_REFS);
                }
            }
        }
            
        //l.add(KEY_SERVICE_REFS);
        //l.add(WEBSERVICES_DIR);

        FileObject docBaseDir = jp.getMetaInf();
        if (docBaseDir != null) {
            l.add(KEY_DOC_BASE);
        }
        
        l.add(KEY_SETUP_DIR);

        l.addAll(getSourceRoots());

        l.add(KEY_LIBRARIES);
        l.add(KEY_TEST_LIBRARIES);

        setKeys(l);
    }

    protected void removeNotify() {
        setKeys(Collections.EMPTY_SET);
        sources.removeChangeListener( this );

        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel!=null) jaxWsModel.removePropertyChangeListener(jaxWsListener);
   
        EjbJar ejbModule = EjbJar.getEjbJar(helper.getProjectDirectory());
        if (ejbModule != null) {
            FileObject metaInf = ejbModule.getMetaInf();
            if (metaInf!=null) {
                metaInf.removeFileChangeListener(metaInfListener);
                metaInf.removeFileChangeListener(jaxrpcChangeListener);
            }
        }
        
        if (wsdlFolder != null) {
            wsdlFolder.removeFileChangeListener(wsdlListener);
        }

        setKeys(Collections.EMPTY_SET);
//        getSources().removeChangeListener( this );

        super.removeNotify();
    }

    public Node[] createNodes(Object key) {
        Node n = null;
        if (key instanceof SourceGroupKey) {
            n = new PackageViewFilterNode(((SourceGroupKey) key).group, project);
        } else if (key == KEY_DOC_BASE) {
            n = J2eeProjectView.createConfigFilesView(jp.getMetaInf());
        } else if (key == KEY_EJBS) {
            org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = null;
            FileObject dd = jp.getDeploymentDescriptor();
            try {
                ejbJar = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(jp.getMetadataUnit());
            } catch (IOException ioe) {
                ErrorManager.getDefault().notify(ioe);
            }
            if ((ejbJar != null && !ejbJar.getVersion().equals(new BigDecimal(ejbJar.VERSION_3_0))) || DISPLAY_EJB_NODE) {
                n = J2eeProjectView.createEjbsView(ejbJar, cp, dd, project);
            }
        } else if ((key == KEY_ORM) && DISPLAY_ORM_NODE) {
            EntityMappings entityMappings = PersistenceUtils.getAnnotationEntityMappings(project);
            if (entityMappings != null) {
                n = new PersistenceNode(entityMappings, cp);
            }
        } else if (key == WEBSERVICES_DIR){
            EjbJar ejbModule = EjbJar.getEjbJar(helper.getProjectDirectory());
            
            java.util.Map properties = ((EjbJarProject)project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
            String serverInstance = (String)properties.get("j2ee.server.instance"); //NOI18N
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
            boolean jwsdpSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_JWSDP);
            
            if (ejbModule!=null && ((EjbProjectConstants.JAVA_EE_5_LEVEL.equals(ejbModule.getJ2eePlatformVersion())) || (jwsdpSupported))) {
                JAXWSView view = JAXWSView.getJAXWSView();
                n = view.createJAXWSView(project);
            } else {
                SourceGroup[] srcGroup = sources.getSourceGroups(JavaProjectConstants.SOURCES_TYPE_JAVA);
                if (srcGroup.length > 0) {
                    FileObject srcRoot = srcGroup[0].getRootFolder();
                    if (srcRoot != null) {
                        WebServicesView webServicesView = WebServicesView.getWebServicesView(srcRoot);
                        if (webServicesView != null) {
                            n = webServicesView.createWebServicesView(srcRoot);
                        }
                    }
                }
            }
        } else if (key == KEY_SETUP_DIR) {
            n = J2eeProjectView.createServerResourcesNode(project);
        } else if (key == KEY_LIBRARIES) {
            assert updateHelper != null;
            assert evaluator != null;
            assert refHelper != null;
            n = new LibrariesNode(
                NbBundle.getMessage(LogicalViewChildren.class,"CTL_LibrariesNode"),
                project,
                evaluator,
                updateHelper,
                refHelper,
                EjbJarProjectProperties.JAVAC_CLASSPATH,
                new String[] { EjbJarProjectProperties.BUILD_CLASSES_DIR },
                "platform.active", //NOI18N
                EjbJarProjectProperties.J2EE_SERVER_INSTANCE,
                new Action[] {
                    LibrariesNode.createAddProjectAction(project, EjbJarProjectProperties.JAVAC_CLASSPATH,
                                                         ClassPathSupport.ELEMENT_INCLUDED_LIBRARIES),
                    LibrariesNode.createAddLibraryAction(project, updateHelper.getAntProjectHelper(),
                                                         EjbJarProjectProperties.JAVAC_CLASSPATH, ClassPathSupport.ELEMENT_INCLUDED_LIBRARIES),
                    LibrariesNode.createAddFolderAction(project, EjbJarProjectProperties.JAVAC_CLASSPATH,
                                                        ClassPathSupport.ELEMENT_INCLUDED_LIBRARIES),
                    null,
                    new PreselectPropertiesAction(project, "Libraries", CustomizerLibraries.COMPILE), //NOI18N
                },
                ClassPathSupport.ELEMENT_INCLUDED_LIBRARIES
            );
        } 
        else if (key == KEY_SERVICE_REFS) {
            // !PW FIXME This needs to be a stable way to retrieve a FileObject, e.g. for META-INF
            // (or we could use some other type) that will uniquely define the WebServicesClientView
            // we want to retrieve.
            
            java.util.Map properties = ((EjbJarProject)project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
            String serverInstance = (String)properties.get("j2ee.server.instance"); //NOI18N
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
            boolean jwsdpSupported = j2eePlatform!=null && j2eePlatform.isToolSupported(J2eePlatform.TOOL_JWSDP);

            EjbJar ejbModule = EjbJar.getEjbJar(project.getProjectDirectory());
            if (ejbModule!=null && ((EjbProjectConstants.JAVA_EE_5_LEVEL.equals(ejbModule.getJ2eePlatformVersion())) || (jwsdpSupported))) {
                JAXWSClientView view = JAXWSClientView.getJAXWSClientView();
                n = view.createJAXWSClientView(project);
            } else {
                FileObject clientRoot = helper.resolveFileObject(evaluator.getProperty(EjbJarProjectProperties.META_INF));
                if(clientRoot == null) {
                    clientRoot = helper.resolveFileObject(evaluator.getProperty(EjbJarProjectProperties.SRC_DIR));
                }
                if (clientRoot != null) {
                    WebServicesClientView clientView = WebServicesClientView.getWebServicesClientView(clientRoot);

                    if(clientView != null) {
                        WebServicesClientSupport wss = WebServicesClientSupport.getWebServicesClientSupport(clientRoot);
                        if (wss != null) {
                            FileObject wsdlFolder = wss.getWsdlFolder();

                            // Only display this node if there is a WSDL folder (too
                            // difficult to handle without.)
                            if(wsdlFolder != null) {
                                n = clientView.createWebServiceClientView(wsdlFolder);
                            }
                        }
                    }
                }
            }
        }
        else if (key == KEY_TEST_LIBRARIES) {
            n = new LibrariesNode(
                NbBundle.getMessage(LogicalViewChildren.class,"CTL_TestLibrariesNode"),
                project,
                evaluator,
                updateHelper,
                refHelper,
                EjbJarProjectProperties.JAVAC_TEST_CLASSPATH,
                new String[] {
                    EjbJarProjectProperties.BUILD_TEST_CLASSES_DIR,
                    EjbJarProjectProperties.JAVAC_CLASSPATH,
                    EjbJarProjectProperties.BUILD_CLASSES_DIR,
                },
                null,
                null,
                new Action[] {
                    LibrariesNode.createAddProjectAction(project, EjbJarProjectProperties.JAVAC_TEST_CLASSPATH, null),
                    LibrariesNode.createAddLibraryAction(project, updateHelper.getAntProjectHelper(), EjbJarProjectProperties.JAVAC_TEST_CLASSPATH, null),
                    LibrariesNode.createAddFolderAction(project, EjbJarProjectProperties.JAVAC_TEST_CLASSPATH, null),
                    null,
                    new PreselectPropertiesAction(project, "Libraries", CustomizerLibraries.COMPILE_TESTS), //NOI18N
                },
                null
            );
        }

        return n == null ? new Node[0] : new Node[] {n};
    }

    public void stateChanged( ChangeEvent e ) {
        //The caller holds ProjectManager.mutex() read lock
        SwingUtilities.invokeLater (new Runnable () {
            public void run () {
                createNodes();
            }
        });
    }

    private Collection getSourceRoots() {
        SourceGroup[] groups = sources.getSourceGroups( JavaProjectConstants.SOURCES_TYPE_JAVA );
        List result = new ArrayList(groups.length);
        for (int i = 0; i < groups.length; i++) {
            result.add(new SourceGroupKey(groups[i]));
        }
        return result;
    }
    
    private static class SourceGroupKey {

        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey( SourceGroup group ) {
            this.group = group;
            this.fileObject = group.getRootFolder();
        }

        public int hashCode() {
            return fileObject.hashCode();
        }

        public boolean equals( Object obj ) {
            if ( !(obj instanceof SourceGroupKey) ) {
                return false;
            }
            else {
                SourceGroupKey otherKey = (SourceGroupKey)obj;
                String thisDisplayName = this.group.getDisplayName();
                String otherDisplayName = otherKey.group.getDisplayName ();
                return fileObject.equals(otherKey.fileObject ) &&
                     thisDisplayName == null ?  otherDisplayName == null : thisDisplayName.equals(otherDisplayName);
            }
        }
    }

//    private final class WsdlCreationListener extends FileChangeAdapter {
//        public void fileFolderCreated (FileEvent fe) {
//            // !PW Could screen this for WSDL directory, but it is probably
//            // cheaper to just always refresh.  How many folders is the
//            // user likely to create in WEB-INF anyway?
//            SwingUtilities.invokeLater(new Runnable() {
//                public void run() {
//                    refreshKey(KEY_SERVICE_REFS);
//                }
//            });
//        }
//    }
    
    /** Yet another cool filter node just to add properties action
     */
    private static class PackageViewFilterNode extends FilterNode {
        
        private String nodeName;
        private Project project;
        private Action[] actions;
        
        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(PackageView.createPackageView(sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }
        
        public Action[] getActions(boolean context) {
            if (!context) {
                if (actions == null) {
                    Action superActions[] = super.getActions(context);
                    actions = new Action[superActions.length + 2];
                    System.arraycopy(superActions, 0, actions, 0, superActions.length);
                    actions[superActions.length] = null;
                    actions[superActions.length + 1] = new PreselectPropertiesAction(project, nodeName, null);
                }
                return actions;
            } else {
                return super.getActions(context);
            }
        }
    }
    
    private static class PreselectPropertiesAction extends AbstractAction {

        private Project project;
        private String nodeName;
        private String panelName;

        public PreselectPropertiesAction( Project project, String nodeName, String panelName ) {
            super( NbBundle.getMessage( LogicalViewChildren.class, "LBL_Properties_Action" ) );
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }

        public void actionPerformed( ActionEvent e ) {
            CustomizerProviderImpl cp = (CustomizerProviderImpl)project.getLookup().lookup( CustomizerProviderImpl.class );
            if ( cp != null ) {
                cp.showCustomizer( nodeName, panelName );
            }
        }
    }
    
    private final class JaxWsChangeListener implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {

            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    createNodes();
                }
            });
        }
    }
    
    private final class MetaInfListener extends FileChangeAdapter {
        public void fileFolderCreated (FileEvent fe) {
            if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) { //NOI18N
                fe.getFile().addFileChangeListener(wsdlListener);
                wsdlFolder=fe.getFile();
            }
        }
        public void fileDeleted (FileEvent fe) {
            if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) { //NOI18N
                fe.getFile().removeFileChangeListener(wsdlListener);
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        refreshKey(KEY_SERVICE_REFS);
                    }
                });
            }
        }
    }
    
    private final class WsdlCreationListener extends FileChangeAdapter {

        public void fileDataCreated (FileEvent fe) {
            if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) { //NOI18N
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        refreshKey(KEY_SERVICE_REFS);
                    }
                });
            }
        }

        public void fileDeleted (FileEvent fe) {
            if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) { //NOI18N
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        refreshKey(KEY_SERVICE_REFS);
                    }
                });
            }
        }
    }
    
    private final class JaxRPCChangeListener extends FileChangeAdapter {

        String webservicesFile = "webservices.xml";
        public void fileDataCreated (FileEvent fe) {
            if (webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) { //NOI18N
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        createNodes();
                    }
                });
            }
        }

        public void fileDeleted (FileEvent fe) {
            if (webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) { //NOI18N
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        createNodes();
                    }
                });
            }
        }

        public void fileChanged(FileEvent fe) {
            if (webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) { //NOI18N
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        createNodes();
                    }
                });
            }
        }
    }
}


