/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.ejbjarproject.ui.wizards;

import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PanelConfigureProjectAppVisual extends JPanel {

    private PanelConfigureProjectApp panel;

    private PanelProjectAppVisual projectAppPanel;
///    private PanelOptionsVisual optionsPanel;

    /** Creates new form PanelInitProject */
    public PanelConfigureProjectAppVisual(PanelConfigureProjectApp panel) {
        this.panel = panel;
        initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigureProjectAppVisual.class, "ACS_NWP1_AppOptionPanel_A11YDesc"));  // NOI18N
        
        projectAppPanel = new PanelProjectAppVisual(panel);
        locationContainer.add(projectAppPanel, java.awt.BorderLayout.NORTH);

        ///optionsPanel = new PanelOptionsVisual(panel);
        ///optionsContainer.add(optionsPanel, java.awt.BorderLayout.NORTH);

///        DocumentListener dl = new DocumentListener() {
///            public void changedUpdate(DocumentEvent e) {
///                setContextPath(e);
///            }
///
///            public void insertUpdate(DocumentEvent e) {
///                setContextPath(e);
///            }
///
///            public void removeUpdate(DocumentEvent e) {
///                setContextPath(e);
///            }

///            private void setContextPath(DocumentEvent e) {
///                if (!optionsPanel.isContextModified())
///                    optionsPanel.jTextFieldContextPath.setText("/" + projectAppPanel.projectNameTextField.getText().trim().replace(' ', '_'));
///            }
///        };
///        projectAppPanel.projectNameTextField.getDocument().addDocumentListener(dl);


        // Provide a name in the title bar.
        setName(NbBundle.getBundle("org/netbeans/modules/j2ee/ejbjarproject/ui/wizards/Bundle").getString("LBL_NWP1_ProjectAppName")); //NOI18N
        putClientProperty ("NewProjectWizard_Title", NbBundle.getMessage(PanelConfigureProjectVisual.class, "TXT_NewWebApp")); //NOI18N
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return projectAppPanel.valid(wizardDescriptor);
    }

    void read (WizardDescriptor d) {
        projectAppPanel.read(d);
///        optionsPanel.read(d);
    }

    void store(WizardDescriptor d) {
        projectAppPanel.store(d);
///        optionsPanel.store(d);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        locationContainer = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(550, 350));
        setRequestFocusEnabled(false);
        locationContainer.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(locationContainer, gridBagConstraints);

    }//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel locationContainer;
    // End of variables declaration//GEN-END:variables

}
