/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.metadata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

/**
 * Use this class to create classpath without some roots.
 * 
 * @author Tomas Zezula
 */
public class StrippedClassPathImpl implements ClassPathImplementation, PropertyChangeListener {
    
    private final ClassPath orig;
    private final Set<URL> appSrvRoots;
    private final PropertyChangeSupport support;
    private List<PathResourceImplementation> resources;
    
    public StrippedClassPathImpl(final ClassPath orig, final File[] appSrvRoots) {
        assert orig != null;
        assert appSrvRoots != null;
        this.orig = orig;
        this.appSrvRoots = new HashSet<URL>();
        this.support = new PropertyChangeSupport(this);
        for (File f : appSrvRoots) {
            URL fileRoot = null;
            try {
                fileRoot = f.toURI().toURL();
            } catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(ex);
            }
            if (FileUtil.isArchiveFile(fileRoot)) {
                fileRoot = FileUtil.getArchiveRoot(fileRoot);
            }
            this.appSrvRoots.add(fileRoot);
        }
        this.orig.addPropertyChangeListener(WeakListeners.propertyChange(this, this.orig));
    }
    
    public synchronized List<PathResourceImplementation> getResources() {
        if (resources == null) {
            this.resources = new ArrayList<PathResourceImplementation> ();
            List<ClassPath.Entry> entries = orig.entries();
            for (ClassPath.Entry entry : entries) {
                URL url = entry.getURL();
                if (!this.appSrvRoots.contains(url)) {
                    this.resources.add(ClassPathSupport.createResource(url));
                }
            }
        }
        return this.resources;
    }
    
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        assert listener != null;
        this.support.addPropertyChangeListener(listener);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        assert listener != null;
        this.support.removePropertyChangeListener(listener);
    }
    
    public void propertyChange(PropertyChangeEvent event) {
        synchronized (this) {
            this.resources = null;
        }
        this.support.firePropertyChange(PROP_RESOURCES, null, null);
    }
    
}

